/*
 * Decompiled with CFR 0.152.
 */
package com.ttl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ttl.Rates;
import com.ttl.TimeToLevelPlugin;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import joptsimple.internal.Strings;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RatesManager {
    private static final Logger log = LoggerFactory.getLogger(RatesManager.class);
    private static final Gson gson = new Gson();
    private List<Rates> cachedRates;
    ConfigManager configManager;

    @Inject
    public RatesManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public synchronized List<Rates> getRates() {
        return this.getRates(true);
    }

    private synchronized List<Rates> getRates(boolean useConfig) {
        if (useConfig && this.cachedRates != null) {
            return this.cachedRates;
        }
        this.cachedRates = useConfig && !Strings.isNullOrEmpty((String)this.getRatesConfig()) ? this.getConfigRates() : this.getDefaultRates();
        return this.cachedRates;
    }

    private List<Rates> getConfigRates() {
        return (List)gson.fromJson(this.getRatesConfig(), RatesManager.tt());
    }

    private List<Rates> getDefaultRates() {
        return (List)gson.fromJson((Reader)new InputStreamReader(TimeToLevelPlugin.class.getResourceAsStream("/rates.json")), RatesManager.tt());
    }

    public Rates getRates(Skill skill) {
        return this.getRates(skill, true);
    }

    private Rates getRates(Skill skill, boolean useConfig) {
        return this.getRates(useConfig).stream().filter(r -> r.getSkill().equals(skill.name().toLowerCase())).findFirst().map(Rates::new).orElse(null);
    }

    public synchronized void saveRates(Rates r) {
        List<Rates> allRates = this.getRates();
        for (int i = 0; i < allRates.size(); ++i) {
            Rates allR = allRates.get(i);
            if (!allR.getSkill().equals(r.getSkill())) continue;
            allRates.set(i, r);
            this.cachedRates = allRates;
            this.configManager.setConfiguration("timetolevel", "rates", gson.toJson(this.cachedRates));
            break;
        }
    }

    public void resetRates() {
        InputStream ratesStream = TimeToLevelPlugin.class.getResourceAsStream("/rates.json");
        this.cachedRates = (List)gson.fromJson((Reader)new InputStreamReader(ratesStream), new TypeToken<List<Rates>>(){}.getType());
        this.configManager.setConfiguration("timetolevel", "rates", gson.toJson(this.cachedRates));
        this.configManager.setConfiguration("timetolevel", "buyableSkills", "cooking,smithing,fletching,firemaking,herblore,crafting,construction,prayer,ranged,magic,farming");
    }

    public String getRatesConfig() {
        return this.configManager.getConfiguration("timetolevel", "rates");
    }

    public boolean setRatesConfig(String rates) {
        if (rates == null || rates.isEmpty()) {
            return false;
        }
        this.cachedRates = (List)gson.fromJson(rates, RatesManager.tt());
        this.configManager.setConfiguration("timetolevel", "rates", gson.toJson(this.cachedRates));
        return true;
    }

    private static Type tt() {
        return new TypeToken<List<Rates>>(){}.getType();
    }

    public Rates resetRates(Skill skill) {
        Rates r = this.getRates(skill, false);
        this.saveRates(r);
        return r;
    }
}

