/*
 * Decompiled with CFR 0.152.
 */
package com.ttl;

import com.ttl.RateMethod;
import net.runelite.api.Skill;
import net.runelite.client.util.QuantityFormatter;

public class RateTTL {
    Skill skill;
    int level;
    int xpLeft;
    int xpRate;
    int secondsLeft;
    RateMethod info;

    public String ttl() {
        if (this.secondsLeft < 0) {
            return "\u221e";
        }
        long durationHours = this.secondsLeft / 3600;
        long durationMinutes = this.secondsLeft % 3600 / 60;
        long durationSeconds = this.secondsLeft % 60;
        if (durationHours > 0L) {
            return String.format("%02d:%02d:%02d", durationHours, durationMinutes, durationSeconds);
        }
        return String.format("%02d:%02d", durationMinutes, durationSeconds);
    }

    public String toolTip() {
        return String.format("<html>Lvl %d<br>%s xp/hr<br>%s</html>", this.info.getLevel(), QuantityFormatter.quantityToRSDecimalStack((int)this.info.getRate()), this.info.getMethod());
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getLevel() {
        return this.level;
    }

    public int getXpLeft() {
        return this.xpLeft;
    }

    public int getXpRate() {
        return this.xpRate;
    }

    public int getSecondsLeft() {
        return this.secondsLeft;
    }

    public RateMethod getInfo() {
        return this.info;
    }

    public void setSkill(Skill skill) {
        this.skill = skill;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setXpLeft(int xpLeft) {
        this.xpLeft = xpLeft;
    }

    public void setXpRate(int xpRate) {
        this.xpRate = xpRate;
    }

    public void setSecondsLeft(int secondsLeft) {
        this.secondsLeft = secondsLeft;
    }

    public void setInfo(RateMethod info) {
        this.info = info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateTTL)) {
            return false;
        }
        RateTTL other = (RateTTL)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Skill this$skill = this.getSkill();
        Skill other$skill = other.getSkill();
        if (this$skill == null ? other$skill != null : !this$skill.equals(other$skill)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getXpLeft() != other.getXpLeft()) {
            return false;
        }
        if (this.getXpRate() != other.getXpRate()) {
            return false;
        }
        if (this.getSecondsLeft() != other.getSecondsLeft()) {
            return false;
        }
        RateMethod this$info = this.getInfo();
        RateMethod other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateTTL;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Skill $skill = this.getSkill();
        result = result * 59 + ($skill == null ? 43 : $skill.hashCode());
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getXpLeft();
        result = result * 59 + this.getXpRate();
        result = result * 59 + this.getSecondsLeft();
        RateMethod $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "RateTTL(skill=" + this.getSkill() + ", level=" + this.getLevel() + ", xpLeft=" + this.getXpLeft() + ", xpRate=" + this.getXpRate() + ", secondsLeft=" + this.getSecondsLeft() + ", info=" + this.getInfo() + ")";
    }

    public RateTTL(Skill skill, int level, int xpLeft, int xpRate, int secondsLeft, RateMethod info) {
        this.skill = skill;
        this.level = level;
        this.xpLeft = xpLeft;
        this.xpRate = xpRate;
        this.secondsLeft = secondsLeft;
        this.info = info;
    }
}

