/*
 * Decompiled with CFR 0.152.
 */
package com.normalancientteleports;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.normalancientteleports.NormalAncientTeleportsConfig;
import com.normalancientteleports.NormalAncientTeleportsSpellData;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Normal Ancient Teleports")
public class NormalAncientTeleportsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NormalAncientTeleportsPlugin.class);
    private final String DEF_FILE_SPELLS = "spells.json";
    @Inject
    private Client client;
    @Inject
    private NormalAncientTeleportsConfig config;
    @Inject
    private Gson gson;
    private List<NormalAncientTeleportsSpellData> spells;

    protected void startUp() throws Exception {
        InputStream resourceStream = NormalAncientTeleportsSpellData.class.getResourceAsStream("spells.json");
        InputStreamReader definitionReader = new InputStreamReader(resourceStream);
        this.spells = Arrays.asList((NormalAncientTeleportsSpellData[])this.gson.fromJson((Reader)definitionReader, NormalAncientTeleportsSpellData[].class));
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (this.spells == null) {
            return;
        }
        if (e.getGroupId() == 218) {
            this.spells.forEach(spell -> {
                Widget widget = this.client.getWidget(spell.widgetID);
                String newText = widget.getName().replaceAll(spell.originalName, spell.newName);
                widget.setName(newText);
            });
        } else if (e.getGroupId() == 17 && this.config.replacePortalNexus()) {
            Widget widget = this.client.getWidget(17, 12);
            for (Widget w : widget.getChildren()) {
                this.spells.forEach(spell -> {
                    if (w.getText().contains(spell.originalName)) {
                        String newText = w.getText().replaceAll(spell.originalName, spell.newName);
                        w.setText(newText);
                    }
                });
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired e) {
        Widget widget = this.client.getWidget(14287047);
        if (widget == null || widget.getChildren() == null) {
            return;
        }
        Widget textWidget = widget.getChild(3);
        this.spells.forEach(spell -> {
            if (textWidget.getText().contains(spell.originalName)) {
                String newText = textWidget.getText().replaceAll(spell.originalName.concat(" Teleport"), spell.newName);
                textWidget.setText(newText);
            }
        });
    }

    @Provides
    NormalAncientTeleportsConfig provideConfig(ConfigManager configManager) {
        return (NormalAncientTeleportsConfig)configManager.getConfig(NormalAncientTeleportsConfig.class);
    }
}

