/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.ui;

import com.gimp.ui.FilledCircle;
import com.gimp.ui.GimTabGroup;
import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BooleanSupplier;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class GimTab
extends JLayeredPane {
    private static final Border SELECTED_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.BRAND_ORANGE), BorderFactory.createEmptyBorder(5, 10, 4, 10));
    private static final Border UNSELECTED_BORDER = BorderFactory.createEmptyBorder(5, 10, 5, 10);
    private static final Color ONLINE_COLOR = new Color(0, 146, 54, 230);
    private static final Color OFFLINE_COLOR = Color.RED;
    private static final int STATUS_DOT_SIZE = 5;
    private final String gimp;
    private final JLabel label;
    private final FilledCircle statusDot;
    private BooleanSupplier onSelectEvent;
    private boolean selected;

    public GimTab(String string, final GimTabGroup group, String gimp) {
        this.gimp = gimp;
        this.setLayout(new BorderLayout());
        this.label = new JLabel(string);
        this.label.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.add((Component)this.label, "Center");
        this.setLayer(this.label, DEFAULT_LAYER);
        this.statusDot = new FilledCircle(5, 5, OFFLINE_COLOR);
        this.add((Component)this.statusDot, "East");
        this.setLayer(this.statusDot, PALETTE_LAYER);
        this.unselect();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                group.select(GimTab.this);
            }
        });
        if (!Strings.isNullOrEmpty((String)string)) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    GimTab tab = (GimTab)e.getSource();
                    tab.setForeground(Color.WHITE);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GimTab tab = (GimTab)e.getSource();
                    if (!tab.isSelected()) {
                        tab.setForeground(Color.GRAY);
                    }
                }
            });
        }
    }

    public GimTab(ImageIcon icon, GimTabGroup group, String gimp) {
        this("", group, gimp);
        this.setOpaque(true);
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.drawLabel(icon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GimTab tab = (GimTab)e.getSource();
                tab.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GimTab tab = (GimTab)e.getSource();
                tab.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
    }

    private void drawLabel(ImageIcon icon) {
        this.label.setIcon(icon);
        this.label.setOpaque(false);
        this.label.setVerticalAlignment(0);
        this.label.setHorizontalAlignment(0);
    }

    public void setStatus(boolean isOnline) {
        Color color = isOnline ? ONLINE_COLOR : OFFLINE_COLOR;
        this.statusDot.setColor(color);
        this.statusDot.repaint();
    }

    public boolean select() {
        if (this.onSelectEvent != null && !this.onSelectEvent.getAsBoolean()) {
            return false;
        }
        this.setBorder(SELECTED_BORDER);
        this.setForeground(Color.WHITE);
        this.selected = true;
        return true;
    }

    public void unselect() {
        this.setBorder(UNSELECTED_BORDER);
        this.setForeground(Color.GRAY);
        this.selected = false;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    public String getGimp() {
        return this.gimp;
    }

    public void setOnSelectEvent(BooleanSupplier onSelectEvent) {
        this.onSelectEvent = onSelectEvent;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

