/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.tasks;

import com.gimp.tasks.Task;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    @Inject
    private Timer timer;

    public void schedule(final Task task, long delay) {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                task.run();
                long nextDelay = task.delay();
                if (nextDelay != 0L) {
                    TaskManager.this.schedule(task, nextDelay);
                }
            }
        };
        this.timer.schedule(timerTask, delay);
    }

    public void resetTasks() {
        this.timer.purge();
        this.timer.cancel();
        this.timer = new Timer();
    }
}

