/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.requests;

import com.gimp.GimPluginConfig;
import com.gimp.requests.RequestClient;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient
extends RequestClient {
    private static final Logger log = LoggerFactory.getLogger(SocketClient.class);
    public Socket client;
    private static final String EVENT_CONNECTION_ACK = "connection-ack";

    public SocketClient(String namespace, GimPluginConfig config) {
        this.namespace = namespace;
        this.config = config;
    }

    public void connect() {
        if (!this.validateUrl()) {
            log.warn("Invalid socket URL, aborting");
            return;
        }
        URI uri = URI.create(this.getBaseUrl());
        IO.Options options = IO.Options.builder().setForceNew(false).setMultiplex(true).setTransports(new String[]{"polling", "websocket"}).setUpgrade(true).setRememberUpgrade(false).setPath("/socket.io/").setQuery(null).setExtraHeaders(null).setReconnection(true).setReconnectionAttempts(Integer.MAX_VALUE).setReconnectionDelay(1000L).setReconnectionDelayMax(5000L).setRandomizationFactor(0.5).setTimeout(20000L).setAuth(null).build();
        if (this.client != null) {
            this.client.close();
        }
        this.client = IO.socket(uri, options);
        this.client.connect();
        this.client.on("connect", args -> {
            log.debug("Socket connected");
            String roomId = this.namespace;
            this.client.emit(EVENT_CONNECTION_ACK, roomId);
        });
        this.client.on("disconnect", args -> log.debug("Socket disconnected"));
        this.client.on("connect_error", args -> {
            log.warn("Failed to connect to socket server, closing");
            this.client.close();
        });
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public boolean isConnected() {
        if (this.client != null) {
            return this.client.connected();
        }
        return false;
    }

    @Override
    public CompletableFuture<String> ping() {
        String EVENT_PING = "ping";
        CompletableFuture<String> socketResponse = new CompletableFuture<String>();
        this.client.emit(EVENT_PING, args -> {
            JSONObject data = (JSONObject)args[0];
            socketResponse.complete(data.toString());
        });
        return socketResponse;
    }

    @Override
    public CompletableFuture<String> broadcast(String dataJson) {
        String EVENT_BROADCAST = "broadcast";
        CompletableFuture<String> socketResponse = new CompletableFuture<String>();
        this.client.emit(EVENT_BROADCAST, dataJson, args -> {
            JSONObject data = (JSONObject)args[0];
            socketResponse.complete(data.toString());
        });
        return socketResponse;
    }

    public Socket getClient() {
        return this.client;
    }
}

