/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.map;

import com.gimp.gimps.GimPlayer;
import com.gimp.map.GimIconProvider;
import com.gimp.map.GimWorldMapPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimWorldMapPointManager {
    private static final Logger log = LoggerFactory.getLogger(GimWorldMapPointManager.class);
    @Inject
    private WorldMapPointManager _worldMapPointManager;
    private final Map<String, GimWorldMapPoint> points = new HashMap<String, GimWorldMapPoint>();
    private final Map<String, Collection<WorldMapPoint>> associatedPoints = new HashMap<String, Collection<WorldMapPoint>>();
    private final GimIconProvider iconProvider = new GimIconProvider();

    public GimWorldMapPoint getPoint(String gimpName) {
        if (!this.points.containsKey(gimpName)) {
            throw new IllegalArgumentException("WorldMapPoint does not exist for user " + gimpName);
        }
        return this.points.get(gimpName);
    }

    public boolean hasPoint(String gimpName) {
        return this.points.containsKey(gimpName);
    }

    public void addPoint(String gimpName, GimWorldMapPoint worldMapPoint) {
        if (this.points.containsKey(gimpName)) {
            throw new IllegalStateException("WorldMapPoint for user " + gimpName + " already exists");
        }
        this.points.put(gimpName, worldMapPoint);
        this.associatedPoints.put(gimpName, new LinkedList());
        this._worldMapPointManager.add(worldMapPoint.getWorldMapPoint());
        log.debug("Add world map point for " + gimpName);
    }

    public void addPoint(GimPlayer gimp) {
        String name = gimp.getName();
        if (gimp.getLocation() != null) {
            WorldPoint p = new WorldPoint(gimp.getLocation().getX(), gimp.getLocation().getY(), gimp.getLocation().getPlane());
            WorldMapPoint worldMapPoint = new WorldMapPoint(p, this.iconProvider.getIcon(name));
            worldMapPoint.setTarget(p);
            worldMapPoint.setSnapToEdge(true);
            worldMapPoint.setJumpOnClick(true);
            worldMapPoint.setName(name);
            this.addPoint(name, new GimWorldMapPoint(gimp, worldMapPoint));
        }
    }

    public void removePoint(String gimpName) {
        if (this.points.containsKey(gimpName)) {
            this._worldMapPointManager.remove(this.points.get(gimpName).getWorldMapPoint());
            this.points.remove(gimpName);
            for (WorldMapPoint point : this.associatedPoints.get(gimpName)) {
                this._worldMapPointManager.removeIf(wmp -> wmp == point);
            }
        } else {
            throw new IllegalStateException("Cannot remove nonexistent WorldMapPoint for user " + gimpName);
        }
        this.associatedPoints.remove(gimpName);
        log.debug("Remove map point for " + gimpName);
    }

    public void addAssociatedPoint(String gimpName, WorldMapPoint associatedPoint) {
        this.associatedPoints.get(gimpName).add(associatedPoint);
        this._worldMapPointManager.add(associatedPoint);
        this._worldMapPointManager.remove(this.points.get(gimpName).getWorldMapPoint());
        this._worldMapPointManager.add(this.points.get(gimpName).getWorldMapPoint());
    }

    public void removeAssociatedPoint(String gimpName, WorldMapPoint worldMapPoint) {
        this.associatedPoints.get(gimpName).removeIf(wmp -> wmp == worldMapPoint);
        this._worldMapPointManager.removeIf(wmp -> wmp == worldMapPoint);
    }

    public void clear() {
        ArrayList<String> gimpNames = new ArrayList<String>(this.points.keySet());
        for (String gimpName : gimpNames) {
            if (!this.hasPoint(gimpName)) continue;
            this.removePoint(gimpName);
        }
    }
}

