/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.map;

import com.gimp.GimPlugin;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

public class GimIconProvider {
    static final Font FONT = FontManager.getRunescapeBoldFont();
    private final Map<String, BufferedImage> icons = new HashMap<String, BufferedImage>(5);

    public BufferedImage getIcon(String name) {
        return this.icons.computeIfAbsent(name, this::generateIcon);
    }

    private BufferedImage generateIcon(String name) {
        Rectangle2D textBounds = FONT.getStringBounds(name, new FontRenderContext(null, true, true));
        int textHeight = (int)textBounds.getHeight();
        int textWidth = (int)textBounds.getWidth();
        BufferedImage gimpLogo = ImageUtil.loadImageResource(GimPlugin.class, (String)"gimpoint.png");
        BufferedImage icon = new BufferedImage(textWidth + 4, gimpLogo.getHeight() + 2 * textHeight, 2);
        Graphics2D graphics = (Graphics2D)icon.getGraphics();
        graphics.drawImage((Image)gimpLogo, (icon.getWidth() - gimpLogo.getWidth()) / 2, (icon.getHeight() - gimpLogo.getHeight()) / 2, null);
        int textX = (icon.getWidth() - textWidth) / 2;
        int textY = textHeight;
        graphics.setFont(FontManager.getRunescapeBoldFont());
        graphics.setColor(Color.BLACK);
        graphics.drawString(name, textX + 1, textY + 1);
        graphics.setColor(Color.WHITE);
        graphics.drawString(name, textX, textY);
        return icon;
    }
}

