/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.gimps;

import java.util.HashMap;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimLocation {
    private static final Logger log = LoggerFactory.getLogger(GimLocation.class);
    final int x;
    final int y;
    final int plane;

    public GimLocation(WorldPoint worldPoint) {
        this.x = worldPoint.getX();
        this.y = worldPoint.getY();
        this.plane = worldPoint.getPlane();
    }

    public GimLocation(int x, int y, int plane) {
        this.x = x;
        this.y = y;
        this.plane = plane;
    }

    public Map<String, Integer> getLocation() {
        HashMap<String, Integer> location = new HashMap<String, Integer>();
        location.put(Coordinate.x.toString(), this.x);
        location.put(Coordinate.y.toString(), this.y);
        location.put(Coordinate.plane.toString(), this.plane);
        return location;
    }

    public WorldPoint toWorldPoint() {
        return new WorldPoint(this.x, this.y, this.plane);
    }

    public double getDistanceTo(GimLocation other) {
        return Math.sqrt(Math.pow(other.x - this.x, 2.0) + Math.pow(other.y - this.y, 2.0));
    }

    public static boolean compare(GimLocation loc1, GimLocation loc2) {
        return loc1.getX() == loc2.getX() && loc1.getY() == loc2.getY() && loc1.getPlane() == loc2.getPlane();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getPlane() {
        return this.plane;
    }

    public static enum Coordinate {
        plane,
        x,
        y;

    }
}

