/*
 * Decompiled with CFR 0.152.
 */
package com.gimp;

import com.gimp.GimPlugin;
import com.gimp.gimps.GimPlayer;
import com.gimp.gimps.Group;
import com.gimp.ui.GimNotes;
import com.gimp.ui.GimTab;
import com.gimp.ui.GimTabGroup;
import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Player;
import net.runelite.api.clan.ClanChannel;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.hiscore.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ProgressBar;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimPluginPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(GimPluginPanel.class);
    private static final ImageIcon GIMP_ICON_SMALL;
    private static final ImageIcon GITHUB_ICON;
    private static final List<HiscoreSkill> SKILLS;
    private static final List<HiscoreSkill> BOSSES;
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private final Group group;
    @Inject
    private Client client;
    private final Map<HiscoreSkill, JLabel> skillLabels = new HashMap<HiscoreSkill, JLabel>();
    private static final Color HP_FG;
    private static final Color HP_BG;
    private static final Color PRAYER_FG;
    private static final Color PRAYER_BG;
    private static final String CONNECTING_TEXT = "Trying to connect...";
    private final JLabel noDataLabel = new JLabel();
    private final JLabel connectionLabel = new JLabel();
    private final JLabel usernameLabel = new JLabel();
    private final JLabel worldLabel = new JLabel();
    private final ProgressBar hpBar = new ProgressBar();
    private final ProgressBar prayerBar = new ProgressBar();
    private final JButton refreshButton = new JButton("Refresh");
    private final JLabel activityLabel = new JLabel();
    private final GimNotes gimNotes = new GimNotes();
    private GimTabGroup tabGroup;
    private int defaultTab;
    private String selectedGimp;
    private boolean loading = false;

    @Inject
    public GimPluginPanel(GimPlugin plugin) {
        this.group = plugin.getGroup();
        this.gimNotes.init(plugin);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
    }

    public void load() {
        Player localPlayer = this.client.getLocalPlayer();
        List<String> gimps = this.group.getNames();
        try {
            SwingUtilities.invokeLater(() -> {
                this.removeAll();
                JPanel container = new JPanel();
                container.setBackground(ColorScheme.DARK_GRAY_COLOR);
                container.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.insets = new Insets(0, 0, 10, 0);
                JPanel statusPanel = this.makeStatusPanel();
                container.add((Component)statusPanel, c);
                ++c.gridy;
                int gimpCount = gimps.size();
                this.tabGroup = new GimTabGroup();
                this.tabGroup.setLayout(new GridLayout(1, gimpCount, 7, 7));
                int tabIdx = 0;
                for (String username : gimps) {
                    GimTab tab = new GimTab(GIMP_ICON_SMALL, this.tabGroup, username);
                    if (this.group.getCurrentWorld(username) != 0) {
                        tab.setStatus(true);
                    }
                    tab.setToolTipText(username);
                    tab.setOnSelectEvent(() -> {
                        if (this.loading) {
                            return false;
                        }
                        this.selectedGimp = username;
                        tab.requestFocus();
                        return true;
                    });
                    tab.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            if (GimPluginPanel.this.loading) {
                                return;
                            }
                            GimPluginPanel.this.loadGimpData();
                        }
                    });
                    if (localPlayer != null && username.equals(localPlayer.getName())) {
                        this.defaultTab = tabIdx;
                    }
                    this.tabGroup.addTab(tab);
                    ++tabIdx;
                }
                this.resetSelectedTab();
                container.add((Component)this.tabGroup, c);
                ++c.gridy;
                JPanel infoPanel = this.makeInfoPanel();
                container.add((Component)infoPanel, c);
                ++c.gridy;
                JPanel statsPanel = new JPanel();
                statsPanel.setLayout(new GridLayout(8, 3));
                statsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                statsPanel.setBorder(new EmptyBorder(5, 0, 2, 0));
                for (HiscoreSkill hiscoreSkill : SKILLS) {
                    JPanel panel = this.makeHiscorePanel(hiscoreSkill);
                    statsPanel.add(panel);
                }
                container.add((Component)statsPanel, c);
                ++c.gridy;
                JPanel bossPanel = new JPanel();
                bossPanel.setLayout(new GridLayout(0, 3));
                bossPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                bossPanel.setBorder(new EmptyBorder(2, 0, 5, 0));
                for (HiscoreSkill skill : BOSSES) {
                    JPanel panel = this.makeHiscorePanel(skill);
                    bossPanel.add(panel);
                }
                container.add((Component)bossPanel, c);
                ++c.gridy;
                this.refreshButton.addActionListener(e -> this.loadGimpData());
                container.add((Component)this.refreshButton, c);
                ++c.gridy;
                JPanel jPanel = this.makeNotesPanel();
                container.add((Component)jPanel, c);
                ++c.gridy;
                this.add(container, "Center");
                this.revalidate();
                this.repaint();
                this.loadGimpData();
            });
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    public void unload() {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            JPanel noDataPanel = this.makeNoDataPanel();
            this.add(noDataPanel, "Center");
            this.revalidate();
            this.repaint();
        });
    }

    private JPanel makeNoDataPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.noDataLabel.setFont(FontManager.getRunescapeFont());
        this.noDataLabel.setText("<html><body style='text-align:center;'>You must be logged in to a group ironman to see GIMP data.</body></html>");
        container.add(this.noDataLabel);
        return container;
    }

    private JPanel makeStatusPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout(4, 0));
        statusPanel.setBorder(new EmptyBorder(2, 8, 2, 8));
        JPanel connectionPanel = new JPanel();
        connectionPanel.setLayout(new BorderLayout());
        connectionPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.connectionLabel.setHorizontalAlignment(0);
        this.connectionLabel.setFont(FontManager.getRunescapeFont());
        this.connectionLabel.setText(CONNECTING_TEXT);
        connectionPanel.add(this.connectionLabel);
        statusPanel.add(connectionPanel);
        JButton githubBtn = this.makeGithubButton();
        statusPanel.add((Component)githubBtn, "After");
        return statusPanel;
    }

    private JButton makeGithubButton() {
        final JButton githubBtn = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)githubBtn);
        githubBtn.setIcon(GITHUB_ICON);
        githubBtn.setToolTipText("Report issues or contribute on GitHub");
        githubBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        githubBtn.setUI(new BasicButtonUI());
        githubBtn.addActionListener(ev -> LinkBrowser.browse((String)"https://github.com/davidvorona/gim-plugin"));
        githubBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                githubBtn.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                githubBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        return githubBtn;
    }

    private JPanel makeInfoPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        JPanel overallPanel = new JPanel();
        overallPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        overallPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallPanel.setLayout(new BorderLayout());
        JPanel overallInfo = new JPanel();
        overallInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallInfo.setLayout((LayoutManager)new DynamicGridLayout(3, 1, 0, 4));
        overallInfo.setBorder(new EmptyBorder(2, 10, 2, 10));
        JPanel titleWrapper = new JPanel();
        titleWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        titleWrapper.setLayout((LayoutManager)new DynamicGridLayout(1, 2, 0, 0));
        titleWrapper.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.usernameLabel.setHorizontalAlignment(2);
        this.usernameLabel.setFont(FontManager.getRunescapeBoldFont());
        titleWrapper.add(this.usernameLabel);
        this.worldLabel.setHorizontalAlignment(4);
        this.worldLabel.setFont(FontManager.getRunescapeFont());
        titleWrapper.add(this.worldLabel);
        overallInfo.add(titleWrapper);
        this.activityLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.activityLabel.setHorizontalAlignment(2);
        this.activityLabel.setFont(FontManager.getRunescapeSmallFont());
        overallInfo.add(this.activityLabel);
        JPanel statusWrapper = new JPanel();
        statusWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        statusWrapper.setLayout((LayoutManager)new DynamicGridLayout(2, 1, 0, 2));
        statusWrapper.setBorder(new EmptyBorder(2, 0, 2, 0));
        JPanel hpWrapper = new JPanel();
        hpWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        hpWrapper.setLayout((LayoutManager)new DynamicGridLayout(1, 2, 2, 0));
        this.hpBar.setBackground(HP_BG);
        this.hpBar.setForeground(HP_FG);
        String hpUri = "/skill_icons_small/hitpoints.png";
        ImageIcon hpIcon = new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)hpUri));
        JLabel hpLabel = new JLabel(hpIcon);
        hpWrapper.add(hpLabel);
        hpWrapper.add((Component)this.hpBar);
        JPanel prayerWrapper = new JPanel();
        prayerWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        prayerWrapper.setLayout((LayoutManager)new DynamicGridLayout(1, 2, 2, 0));
        this.prayerBar.setBackground(PRAYER_BG);
        this.prayerBar.setForeground(PRAYER_FG);
        String prayerUri = "/skill_icons_small/prayer.png";
        ImageIcon prayerIcon = new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)prayerUri));
        JLabel prayerLabel = new JLabel(prayerIcon);
        prayerWrapper.add(prayerLabel);
        prayerWrapper.add((Component)this.prayerBar);
        statusWrapper.add(hpWrapper);
        statusWrapper.add(prayerWrapper);
        overallInfo.add(statusWrapper);
        overallPanel.add(overallInfo);
        return overallPanel;
    }

    private JPanel makeHiscorePanel(HiscoreSkill skill) {
        assert (SwingUtilities.isEventDispatchThread());
        HiscoreSkillType skillType = skill == null ? HiscoreSkillType.SKILL : skill.getType();
        JLabel label = new JLabel();
        label.setToolTipText(skill == null ? "Combat" : skill.getName());
        label.setFont(FontManager.getRunescapeSmallFont());
        label.setText(GimPluginPanel.pad("--", skillType));
        String directory = skill == null || skill == HiscoreSkill.OVERALL ? "/skill_icons/" : (skill.getType() == HiscoreSkillType.BOSS ? "/net/runelite/client/plugins/hiscore/bosses/" : "/skill_icons_small/");
        String skillName = skill == null ? "combat" : skill.name().toLowerCase();
        String skillIcon = directory + skillName + ".png";
        log.debug("Loading skill icon from {}", (Object)skillIcon);
        try {
            label.setIcon(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)skillIcon)));
        }
        catch (Exception e) {
            log.debug(e.toString());
        }
        boolean totalLabel = skill == HiscoreSkill.OVERALL || skill == null;
        label.setIconTextGap(totalLabel ? 10 : 4);
        JPanel skillPanel = new JPanel();
        skillPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        skillPanel.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.skillLabels.put(skill, label);
        skillPanel.add(label);
        return skillPanel;
    }

    private JPanel makeNotesPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        JPanel notesPanel = new JPanel();
        notesPanel.setLayout((LayoutManager)new DynamicGridLayout(2, 1, 0, 2));
        notesPanel.setBorder(new EmptyBorder(2, 0, 2, 0));
        JLabel notesLabel = new JLabel();
        notesLabel.setText("Notes");
        notesLabel.setHorizontalAlignment(2);
        notesLabel.setFont(FontManager.getRunescapeBoldFont());
        notesLabel.setForeground(ColorScheme.BRAND_ORANGE);
        notesPanel.add(notesLabel);
        notesPanel.add(this.gimNotes);
        return notesPanel;
    }

    private void loadGimpData() {
        if (this.selectedGimp == null) {
            this.resetSelectedTab();
        }
        String gimpName = this.selectedGimp;
        ClanChannel gimClanChannel = this.client.getClanChannel(1);
        if (gimClanChannel == null) {
            this.loading = false;
            return;
        }
        this.loading = true;
        GimPlayer gimp = this.group.getGimp(gimpName);
        SwingUtilities.invokeLater(() -> {
            this.applyGimpData(gimp);
            for (Map.Entry<HiscoreSkill, JLabel> entry : this.skillLabels.entrySet()) {
                HiscoreSkill skill = entry.getKey();
                JLabel label = entry.getValue();
                HiscoreSkillType skillType = skill == null ? HiscoreSkillType.SKILL : skill.getType();
                label.setText(GimPluginPanel.pad("--", skillType));
                label.setToolTipText(skill == null ? "Combat" : skill.getName());
            }
        });
        this.group.getHiscores(gimpName).whenCompleteAsync((result, ex) -> {
            if (!gimpName.equals(this.selectedGimp)) {
                return;
            }
            if (result == null) {
                this.loading = false;
                return;
            }
            this.loading = false;
            SwingUtilities.invokeLater(() -> {
                this.fillGimpStatusData(gimp, (HiscoreResult)result);
                this.applyHiscoreResult((HiscoreResult)result);
            });
        });
    }

    public void updateGimpData(GimPlayer gimpData) {
        SwingUtilities.invokeLater(() -> {
            if (this.selectedGimp != null && this.selectedGimp.equals(gimpData.getName())) {
                GimPlayer gimp = this.group.getGimp(this.selectedGimp);
                if (gimpData.getHp() != null || gimpData.getMaxHp() != null) {
                    int hpValue = gimpData.getHp() != null ? gimpData.getHp() : gimp.getHp();
                    int maxHpValue = gimpData.getMaxHp() != null ? gimpData.getMaxHp() : gimp.getMaxHp();
                    this.setHpBar(this.selectedGimp, hpValue, maxHpValue);
                }
                if (gimpData.getPrayer() != null || gimpData.getMaxPrayer() != null) {
                    int prayerValue = gimpData.getPrayer() != null ? gimpData.getPrayer() : gimp.getPrayer();
                    int maxPrayerValue = gimpData.getMaxPrayer() != null ? gimpData.getMaxPrayer() : gimp.getMaxPrayer();
                    this.setPrayerBar(this.selectedGimp, prayerValue, maxPrayerValue);
                }
                if (gimpData.getLastActivity() != null) {
                    this.setLastActivity(this.selectedGimp, gimpData.getLastActivity(), gimp.getWorld());
                }
            }
        });
    }

    public void setConnectionStatus(boolean status) {
        String statusText = status ? "Connected" : "Disconnected";
        String openingTags = "<html><body style = 'padding: 5px;color:#989898'>";
        String closingTags = "</body></html>";
        String tooltipText = "<p><span style = 'color:white'>You are currently " + statusText.toLowerCase(Locale.ROOT) + ".</span></p>";
        String helpText = "<p><span style = 'color:white'>To connect, please follow the instructions on the plugin help page.</span></p>";
        this.connectionLabel.setText(statusText);
        this.connectionLabel.setForeground(status ? Color.CYAN : ColorScheme.LIGHT_GRAY_COLOR);
        this.connectionLabel.setToolTipText(openingTags + tooltipText + (String)(status ? "" : " " + helpText) + closingTags);
    }

    public void setHpBar(String gimpName, Integer hp, Integer maxHp) {
        if (this.selectedGimp != null && this.selectedGimp.equals(gimpName)) {
            this.hpBar.setValue(GimPluginPanel.formatStatusValue(hp));
            this.hpBar.setMaximumValue(GimPluginPanel.formatStatusValue(maxHp));
            this.hpBar.setCenterLabel(GimPluginPanel.formatStatusValue(hp) + "/" + GimPluginPanel.formatStatusValue(maxHp));
        }
    }

    public void setPrayerBar(String gimpName, Integer prayer, Integer maxPrayer) {
        if (this.selectedGimp != null && this.selectedGimp.equals(gimpName)) {
            this.prayerBar.setValue(GimPluginPanel.formatStatusValue(prayer));
            this.prayerBar.setMaximumValue(GimPluginPanel.formatStatusValue(maxPrayer));
            this.prayerBar.setCenterLabel(GimPluginPanel.formatStatusValue(prayer) + "/" + GimPluginPanel.formatStatusValue(maxPrayer));
        }
    }

    public void setLastActivity(String gimpName, String activity, int world) {
        if (this.selectedGimp != null && this.selectedGimp.equals(gimpName)) {
            String activityText = activity == null || activity.isEmpty() || activity.equals("IN_GAME_ACTIVITY") ? (world == 0 ? GimPluginPanel.htmlLabelStr("Last activity:", "inactive") : GimPluginPanel.htmlLabelStr("Currently:", "in game")) : (world == 0 ? GimPluginPanel.htmlLabelStr("Last activity:", activity.toLowerCase(Locale.ROOT)) : GimPluginPanel.htmlLabelStr("Currently:", "training " + activity.toLowerCase(Locale.ROOT)));
            this.activityLabel.setText(activityText);
        }
    }

    public void setWorld(String gimpName, int world) {
        boolean isOnline;
        boolean bl = isOnline = world != 0;
        if (this.tabGroup != null) {
            GimTab tab = this.tabGroup.getTab(gimpName);
            tab.setStatus(isOnline);
        }
        if (this.selectedGimp != null && this.selectedGimp.equals(gimpName)) {
            this.worldLabel.setText((String)(isOnline ? "W" + world : "Offline"));
            this.worldLabel.setForeground(isOnline ? Color.GREEN : Color.RED);
        }
    }

    public void setNotes(String gimpName, String notes) {
        if (this.selectedGimp != null && this.selectedGimp.equals(gimpName)) {
            Player localPlayer = this.client.getLocalPlayer();
            boolean isLocal = gimpName.equals(localPlayer.getName());
            this.gimNotes.setEnabled(isLocal);
            Object toolTipText = isLocal ? "Share notes with the group!" : gimpName + "'s notes";
            this.gimNotes.setToolTipText((String)toolTipText);
            this.gimNotes.setNotes(notes);
        }
    }

    private void applyGimpData(GimPlayer gimp) {
        assert (SwingUtilities.isEventDispatchThread());
        String gimpName = gimp.getName();
        this.usernameLabel.setText(gimpName);
        this.setWorld(gimpName, this.group.getCurrentWorld(gimpName));
        this.setHpBar(gimpName, gimp.getHp(), gimp.getMaxHp());
        this.setPrayerBar(gimpName, gimp.getPrayer(), gimp.getMaxPrayer());
        this.setLastActivity(gimpName, gimp.getLastActivity(), gimp.getWorld());
        this.setNotes(gimpName, gimp.getNotes());
    }

    private void fillGimpStatusData(GimPlayer gimp, HiscoreResult result) {
        assert (SwingUtilities.isEventDispatchThread());
        if (gimp.getMaxHp() == null) {
            this.setHpBar(gimp.getName(), gimp.getHp(), result.getSkill(HiscoreSkill.HITPOINTS).getLevel());
        }
        if (gimp.getMaxPrayer() == null) {
            this.setPrayerBar(gimp.getName(), gimp.getPrayer(), result.getSkill(HiscoreSkill.PRAYER).getLevel());
        }
    }

    private void applyHiscoreResult(HiscoreResult result) {
        assert (SwingUtilities.isEventDispatchThread());
        for (Map.Entry<HiscoreSkill, JLabel> entry : this.skillLabels.entrySet()) {
            HiscoreSkill skill = entry.getKey();
            JLabel label = entry.getValue();
            if (skill == null) {
                if (result.getPlayer() != null) {
                    int combatLevel = Experience.getCombatLevel((int)result.getSkill(HiscoreSkill.ATTACK).getLevel(), (int)result.getSkill(HiscoreSkill.STRENGTH).getLevel(), (int)result.getSkill(HiscoreSkill.DEFENCE).getLevel(), (int)result.getSkill(HiscoreSkill.HITPOINTS).getLevel(), (int)result.getSkill(HiscoreSkill.MAGIC).getLevel(), (int)result.getSkill(HiscoreSkill.RANGED).getLevel(), (int)result.getSkill(HiscoreSkill.PRAYER).getLevel());
                    label.setText(Integer.toString(combatLevel));
                }
            } else {
                Skill s = result.getSkill(skill);
                if (s != null) {
                    long exp = s.getExperience();
                    boolean isSkill = skill.getType() == HiscoreSkillType.SKILL;
                    int level = -1;
                    if (!isSkill || exp != -1L) {
                        level = s.getLevel();
                    }
                    if (level != -1) {
                        label.setText(GimPluginPanel.pad(GimPluginPanel.formatLevel(level), skill.getType()));
                    }
                }
            }
            label.setToolTipText(this.detailsHtml(result, skill));
        }
    }

    private String detailsHtml(HiscoreResult result, HiscoreSkill skill) {
        long experience;
        String openingTags = "<html><body style = 'padding: 5px;color:#989898'>";
        String closingTags = "</body></html>";
        Object content = "";
        if (skill == null) {
            double combatLevel = Experience.getCombatLevelPrecise((int)result.getSkill(HiscoreSkill.ATTACK).getLevel(), (int)result.getSkill(HiscoreSkill.STRENGTH).getLevel(), (int)result.getSkill(HiscoreSkill.DEFENCE).getLevel(), (int)result.getSkill(HiscoreSkill.HITPOINTS).getLevel(), (int)result.getSkill(HiscoreSkill.MAGIC).getLevel(), (int)result.getSkill(HiscoreSkill.RANGED).getLevel(), (int)result.getSkill(HiscoreSkill.PRAYER).getLevel());
            double combatExperience = result.getSkill(HiscoreSkill.ATTACK).getExperience() + result.getSkill(HiscoreSkill.STRENGTH).getExperience() + result.getSkill(HiscoreSkill.DEFENCE).getExperience() + result.getSkill(HiscoreSkill.HITPOINTS).getExperience() + result.getSkill(HiscoreSkill.MAGIC).getExperience() + result.getSkill(HiscoreSkill.RANGED).getExperience() + result.getSkill(HiscoreSkill.PRAYER).getExperience();
            content = (String)content + "<p><span style = 'color:white'>Combat</span></p>";
            content = (String)content + "<p><span style = 'color:white'>Exact Combat Level:</span> " + QuantityFormatter.formatNumber((double)combatLevel) + "</p>";
            content = (String)content + "<p><span style = 'color:white'>Experience:</span> " + QuantityFormatter.formatNumber((double)combatExperience) + "</p>";
        } else {
            switch (skill) {
                case CLUE_SCROLL_ALL: {
                    String allRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_ALL).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_ALL).getRank());
                    String beginnerRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_BEGINNER).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_BEGINNER).getRank());
                    String easyRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_BEGINNER).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_EASY).getRank());
                    String mediumRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_MEDIUM).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_MEDIUM).getRank());
                    String hardRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_HARD).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_HARD).getRank());
                    String eliteRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_ELITE).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_ELITE).getRank());
                    String masterRank = result.getSkill(HiscoreSkill.CLUE_SCROLL_MASTER).getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_MASTER).getRank());
                    String all = result.getSkill(HiscoreSkill.CLUE_SCROLL_ALL).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_ALL).getLevel());
                    String beginner = result.getSkill(HiscoreSkill.CLUE_SCROLL_BEGINNER).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_BEGINNER).getLevel());
                    String easy = result.getSkill(HiscoreSkill.CLUE_SCROLL_EASY).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_EASY).getLevel());
                    String medium = result.getSkill(HiscoreSkill.CLUE_SCROLL_MEDIUM).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_MEDIUM).getLevel());
                    String hard = result.getSkill(HiscoreSkill.CLUE_SCROLL_HARD).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_HARD).getLevel());
                    String elite = result.getSkill(HiscoreSkill.CLUE_SCROLL_ELITE).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_ELITE).getLevel());
                    String master = result.getSkill(HiscoreSkill.CLUE_SCROLL_MASTER).getLevel() == -1 ? "0" : QuantityFormatter.formatNumber((long)result.getSkill(HiscoreSkill.CLUE_SCROLL_MASTER).getLevel());
                    content = (String)content + "<p><span style = 'color:white'>Clues</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>All:</span> " + all + " <span style = 'color:white'>Rank:</span> " + allRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Beginner:</span> " + beginner + " <span style = 'color:white'>Rank:</span> " + beginnerRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Easy:</span> " + easy + " <span style = 'color:white'>Rank:</span> " + easyRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Medium:</span> " + medium + " <span style = 'color:white'>Rank:</span> " + mediumRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Hard:</span> " + hard + " <span style = 'color:white'>Rank:</span> " + hardRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Elite:</span> " + elite + " <span style = 'color:white'>Rank:</span> " + eliteRank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Master:</span> " + master + " <span style = 'color:white'>Rank:</span> " + masterRank + "</p>";
                    break;
                }
                case BOUNTY_HUNTER_ROGUE: {
                    Skill bountyHunterRogue = result.getSkill(HiscoreSkill.BOUNTY_HUNTER_ROGUE);
                    String rank = bountyHunterRogue.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)bountyHunterRogue.getRank());
                    content = (String)content + "<p><span style = 'color:white'>Bounty Hunter - Rogue</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    if (bountyHunterRogue.getLevel() <= -1) break;
                    content = (String)content + "<p><span style = 'color:white'>Score:</span> " + QuantityFormatter.formatNumber((long)bountyHunterRogue.getLevel()) + "</p>";
                    break;
                }
                case BOUNTY_HUNTER_HUNTER: {
                    Skill bountyHunterHunter = result.getSkill(HiscoreSkill.BOUNTY_HUNTER_HUNTER);
                    String rank = bountyHunterHunter.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)bountyHunterHunter.getRank());
                    content = (String)content + "<p><span style = 'color:white'>Bounty Hunter - Hunter</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    if (bountyHunterHunter.getLevel() <= -1) break;
                    content = (String)content + "<p><span style = 'color:white'>Score:</span> " + QuantityFormatter.formatNumber((long)bountyHunterHunter.getLevel()) + "</p>";
                    break;
                }
                case LAST_MAN_STANDING: {
                    Skill lastManStanding = result.getSkill(HiscoreSkill.LAST_MAN_STANDING);
                    String rank = lastManStanding.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)lastManStanding.getRank());
                    content = (String)content + "<p><span style = 'color:white'>Last Man Standing</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    if (lastManStanding.getLevel() <= -1) break;
                    content = (String)content + "<p><span style = 'color:white'>Score:</span> " + QuantityFormatter.formatNumber((long)lastManStanding.getLevel()) + "</p>";
                    break;
                }
                case SOUL_WARS_ZEAL: {
                    Skill soulWarsZeal = result.getSkill(HiscoreSkill.SOUL_WARS_ZEAL);
                    String rank = soulWarsZeal.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)soulWarsZeal.getRank());
                    content = (String)content + "<p><span style = 'color:white'>Soul Wars Zeal</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    if (soulWarsZeal.getLevel() <= -1) break;
                    content = (String)content + "<p><span style = 'color:white'>Score:</span> " + QuantityFormatter.formatNumber((long)soulWarsZeal.getLevel()) + "</p>";
                    break;
                }
                case LEAGUE_POINTS: {
                    Skill leaguePoints = result.getSkill(HiscoreSkill.LEAGUE_POINTS);
                    String rank = leaguePoints.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)leaguePoints.getRank());
                    content = (String)content + "<p><span style = 'color:white'>League Points</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    if (leaguePoints.getLevel() <= -1) break;
                    content = (String)content + "<p><span style = 'color:white'>Points:</span> " + QuantityFormatter.formatNumber((long)leaguePoints.getLevel()) + "</p>";
                    break;
                }
                case OVERALL: {
                    Skill requestedSkill = result.getSkill(skill);
                    String rank = requestedSkill.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)requestedSkill.getRank());
                    String exp = requestedSkill.getExperience() == -1L ? "Unranked" : QuantityFormatter.formatNumber((long)requestedSkill.getExperience());
                    content = (String)content + "<p><span style = 'color:white'>" + skill.getName() + "</span></p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Experience:</span> " + exp + "</p>";
                    break;
                }
                default: {
                    int currentLevel;
                    String exp;
                    if (skill.getType() == HiscoreSkillType.BOSS) {
                        String rank = "Unranked";
                        String lvl = null;
                        Skill requestedSkill = result.getSkill(skill);
                        if (requestedSkill != null) {
                            if (requestedSkill.getRank() > -1) {
                                rank = QuantityFormatter.formatNumber((long)requestedSkill.getRank());
                            }
                            if (requestedSkill.getLevel() > -1) {
                                lvl = QuantityFormatter.formatNumber((long)requestedSkill.getLevel());
                            }
                        }
                        content = (String)content + "<p><span style = 'color:white'>Boss:</span> " + skill.getName() + "</p>";
                        content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                        if (lvl == null) break;
                        content = (String)content + "<p><span style = 'color:white'>KC:</span> " + lvl + "</p>";
                        break;
                    }
                    Skill requestedSkill = result.getSkill(skill);
                    long experience2 = requestedSkill.getExperience();
                    String rank = requestedSkill.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)requestedSkill.getRank());
                    String string = exp = experience2 == -1L ? "Unranked" : QuantityFormatter.formatNumber((long)experience2);
                    String remainingXp = experience2 == -1L ? "Unranked" : ((currentLevel = Experience.getLevelForXp((int)((int)experience2))) + 1 <= 126 ? QuantityFormatter.formatNumber((long)((long)Experience.getXpForLevel((int)(currentLevel + 1)) - experience2)) : "0");
                    content = (String)content + "<p><span style = 'color:white'>Skill:</span> " + skill.getName() + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Rank:</span> " + rank + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Experience:</span> " + exp + "</p>";
                    content = (String)content + "<p><span style = 'color:white'>Remaining XP:</span> " + remainingXp + "</p>";
                }
            }
        }
        if (skill != null && skill.getType() == HiscoreSkillType.SKILL && (experience = result.getSkill(skill).getExperience()) >= 0L) {
            int currentXp = (int)experience;
            int currentLevel = Experience.getLevelForXp((int)currentXp);
            int xpForCurrentLevel = Experience.getXpForLevel((int)currentLevel);
            int xpForNextLevel = currentLevel + 1 <= 126 ? Experience.getXpForLevel((int)(currentLevel + 1)) : -1;
            double xpGained = currentXp - xpForCurrentLevel;
            double xpGoal = xpForNextLevel != -1 ? (double)(xpForNextLevel - xpForCurrentLevel) : 100.0;
            int progress = (int)(xpGained / xpGoal * 100.0);
            content = (String)content + "<div style = 'margin-top:3px'><div style = 'background: #070707; border: 1px solid #070707; height: 6px; width: 100%;'><div style = 'height: 6px; width: " + progress + "%; background: #dc8a00;'></div></div></div>";
        }
        return openingTags + (String)content + closingTags;
    }

    private static String htmlLabelInt(String key, int value) {
        String valueStr = QuantityFormatter.quantityToStackSize((long)value);
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    private static String htmlLabelStr(String key, String value) {
        String SPACE_CHAR = " ";
        return "<html><body style = 'color:#a5a5a5'>" + key + SPACE_CHAR + "<span style = 'color:white'>" + value + "</span></body></html>";
    }

    private void resetSelectedTab() {
        this.tabGroup.select(this.tabGroup.getTab(this.defaultTab));
    }

    private static int formatStatusValue(Integer statusValue) {
        if (statusValue == null) {
            return 0;
        }
        return statusValue;
    }

    private static String formatLevel(int level) {
        if (level < 10000) {
            return Integer.toString(level);
        }
        return level / 1000 + "k";
    }

    private static String pad(String str, HiscoreSkillType type) {
        int pad = type == HiscoreSkillType.BOSS ? 4 : 2;
        return StringUtils.leftPad((String)str, (int)pad);
    }

    static {
        SKILLS = ImmutableList.of((Object)HiscoreSkill.ATTACK, (Object)HiscoreSkill.HITPOINTS, (Object)HiscoreSkill.MINING, (Object)HiscoreSkill.STRENGTH, (Object)HiscoreSkill.AGILITY, (Object)HiscoreSkill.SMITHING, (Object)HiscoreSkill.DEFENCE, (Object)HiscoreSkill.HERBLORE, (Object)HiscoreSkill.FISHING, (Object)HiscoreSkill.RANGED, (Object)HiscoreSkill.THIEVING, (Object)HiscoreSkill.COOKING, (Object[])new HiscoreSkill[]{HiscoreSkill.PRAYER, HiscoreSkill.CRAFTING, HiscoreSkill.FIREMAKING, HiscoreSkill.MAGIC, HiscoreSkill.FLETCHING, HiscoreSkill.WOODCUTTING, HiscoreSkill.RUNECRAFT, HiscoreSkill.SLAYER, HiscoreSkill.FARMING, HiscoreSkill.CONSTRUCTION, HiscoreSkill.HUNTER});
        BOSSES = ImmutableList.of((Object)HiscoreSkill.ABYSSAL_SIRE, (Object)HiscoreSkill.ALCHEMICAL_HYDRA, (Object)HiscoreSkill.ARTIO, (Object)HiscoreSkill.BARROWS_CHESTS, (Object)HiscoreSkill.BRYOPHYTA, (Object)HiscoreSkill.CALLISTO, (Object)HiscoreSkill.CALVARION, (Object)HiscoreSkill.CERBERUS, (Object)HiscoreSkill.CHAMBERS_OF_XERIC, (Object)HiscoreSkill.CHAMBERS_OF_XERIC_CHALLENGE_MODE, (Object)HiscoreSkill.CHAOS_ELEMENTAL, (Object)HiscoreSkill.CHAOS_FANATIC, (Object[])new HiscoreSkill[]{HiscoreSkill.COMMANDER_ZILYANA, HiscoreSkill.CORPOREAL_BEAST, HiscoreSkill.CRAZY_ARCHAEOLOGIST, HiscoreSkill.DAGANNOTH_PRIME, HiscoreSkill.DAGANNOTH_REX, HiscoreSkill.DAGANNOTH_SUPREME, HiscoreSkill.DERANGED_ARCHAEOLOGIST, HiscoreSkill.DUKE_SUCELLUS, HiscoreSkill.GENERAL_GRAARDOR, HiscoreSkill.GIANT_MOLE, HiscoreSkill.GROTESQUE_GUARDIANS, HiscoreSkill.HESPORI, HiscoreSkill.KALPHITE_QUEEN, HiscoreSkill.KING_BLACK_DRAGON, HiscoreSkill.KRAKEN, HiscoreSkill.KREEARRA, HiscoreSkill.KRIL_TSUTSAROTH, HiscoreSkill.MIMIC, HiscoreSkill.NEX, HiscoreSkill.NIGHTMARE, HiscoreSkill.PHOSANIS_NIGHTMARE, HiscoreSkill.OBOR, HiscoreSkill.PHANTOM_MUSPAH, HiscoreSkill.SARACHNIS, HiscoreSkill.SCORPIA, HiscoreSkill.SKOTIZO, HiscoreSkill.SPINDEL, HiscoreSkill.TEMPOROSS, HiscoreSkill.THE_GAUNTLET, HiscoreSkill.THE_CORRUPTED_GAUNTLET, HiscoreSkill.THE_LEVIATHAN, HiscoreSkill.THE_WHISPERER, HiscoreSkill.THEATRE_OF_BLOOD, HiscoreSkill.THEATRE_OF_BLOOD_HARD_MODE, HiscoreSkill.THERMONUCLEAR_SMOKE_DEVIL, HiscoreSkill.TOMBS_OF_AMASCUT, HiscoreSkill.TOMBS_OF_AMASCUT_EXPERT, HiscoreSkill.TZKAL_ZUK, HiscoreSkill.TZTOK_JAD, HiscoreSkill.VARDORVIS, HiscoreSkill.VENENATIS, HiscoreSkill.VETION, HiscoreSkill.VORKATH, HiscoreSkill.WINTERTODT, HiscoreSkill.ZALCANO, HiscoreSkill.ZULRAH});
        HP_FG = new Color(0, 146, 54, 230);
        HP_BG = new Color(102, 15, 16, 230);
        PRAYER_FG = new Color(0, 149, 151);
        PRAYER_BG = Color.black;
        BufferedImage gimpIconSmallImg = ImageUtil.loadImageResource(GimPluginPanel.class, (String)"gimpoint-small.png");
        GIMP_ICON_SMALL = new ImageIcon(gimpIconSmallImg);
        BufferedImage githubIcon = ImageUtil.loadImageResource(GimPluginPanel.class, (String)"github.png");
        GITHUB_ICON = new ImageIcon(ImageUtil.resizeImage((BufferedImage)githubIcon, (int)16, (int)16));
    }
}

