/*
 * Decompiled with CFR 0.152.
 */
package com.gimp;

import com.gimp.GimBroadcastManager;
import com.gimp.GimPingOverlay;
import com.gimp.GimPluginConfig;
import com.gimp.GimPluginPanel;
import com.gimp.gimps.GimLocation;
import com.gimp.gimps.GimPlayer;
import com.gimp.gimps.Group;
import com.gimp.map.GimWorldMapPoint;
import com.gimp.map.GimWorldMapPointManager;
import com.gimp.tasks.Task;
import com.gimp.tasks.TaskManager;
import com.google.gson.Gson;
import com.google.inject.Provides;
import io.socket.emitter.Emitter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.externalplugins.ExternalPluginManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.data.PartyTilePingData;
import net.runelite.client.plugins.party.messages.TilePing;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import okhttp3.OkHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GIMP")
public class GimPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GimPlugin.class);
    public static final int OFFLINE_WORLD = 0;
    private static final int MAP_POINT_TICK_PERIOD = 300;
    @Inject
    private TaskManager taskManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private GimPluginConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Group group;
    @Inject
    private Gson gson;
    @Inject
    private GimPingOverlay gimPingOverlay;
    private final List<PartyTilePingData> pendingTilePings = Collections.synchronizedList(new ArrayList());
    @Inject
    private GimWorldMapPointManager gimWorldMapPointManager;
    private GimBroadcastManager gimBroadcastManager;
    private GimPluginPanel panel;
    private NavigationButton navButton;
    private boolean frameToggle;
    private final Emitter.Listener onBroadcastConnect = new Emitter.Listener(){

        @Override
        public void call(Object ... args) {
            GimPlugin.this.panel.setConnectionStatus(true);
        }
    };
    private final Emitter.Listener onBroadcastDisconnect = new Emitter.Listener(){

        @Override
        public void call(Object ... args) {
            GimPlugin.this.panel.setConnectionStatus(false);
        }
    };
    private final Emitter.Listener onBroadcastReconnect = new Emitter.Listener(){

        @Override
        public void call(Object ... args) {
            GimPlugin.this.clientThread.invoke(() -> {
                GimPlugin.this.panel.setConnectionStatus(true);
                GimPlugin.this.group.localUpdate();
                GimPlugin.this.broadcastUpdate(GimPlugin.this.group.getLocalGimp().getGimpData());
                GimPlugin.this.pingForUpdate(false);
            });
        }
    };

    protected void startUp() {
        log.debug("GIMP started!");
        this.addPanel();
        ClanChannel gimClanChannel = this.client.getClanChannel(1);
        if (gimClanChannel != null && this.client.getGameState() == GameState.LOGGED_IN) {
            this.load();
        } else {
            this.panel.unload();
        }
        this.overlayManager.add((Overlay)this.gimPingOverlay);
    }

    protected void shutDown() {
        log.debug("GIMP stopped!");
        this.overlayManager.remove((Overlay)this.gimPingOverlay);
        this.unload();
        this.removePanel();
    }

    private void load() {
        this.group.load().whenCompleteAsync((result, ex) -> {
            this.panel.load();
            this.startBroadcast();
        });
    }

    private void unload() {
        this.stopBroadcast();
        this.gimWorldMapPointManager.clear();
        this.panel.unload();
        this.group.unload();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOGIN_SCREEN || gameState == GameState.HOPPING || gameState == GameState.CONNECTION_LOST) {
            this.unload();
        }
    }

    @Subscribe
    public void onClanChannelChanged(ClanChannelChanged clanChannelChanged) {
        ClanChannel gimClanChannel;
        Player localPlayer = this.client.getLocalPlayer();
        ClanChannel changedClanChannel = clanChannelChanged.getClanChannel();
        if (changedClanChannel != null && localPlayer != null && changedClanChannel == (gimClanChannel = this.client.getClanChannel(1))) {
            String gimClanChannelName = gimClanChannel.getName();
            log.debug("GIM clan joined: " + gimClanChannelName);
            this.load();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            int currentHp = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
            int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
            if (currentHp != localGimp.getHp()) {
                this.updateHp(currentHp);
            }
            if (currentPrayer != localGimp.getPrayer()) {
                this.updatePrayer(currentPrayer);
            }
            for (GimPlayer gimp : this.group.getGimps()) {
                int lastWorld;
                int currentWorld = this.group.getCurrentWorld(gimp.getName());
                if (currentWorld == (lastWorld = gimp.getWorld().intValue())) continue;
                this.updateWorld(gimp, currentWorld);
                if (currentWorld != 0 && lastWorld != 0) continue;
                this.panel.setLastActivity(gimp.getName(), gimp.getLastActivity(), currentWorld);
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            String activity = statChanged.getSkill().toString();
            int currentHp = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
            int currentMaxHp = this.client.getRealSkillLevel(Skill.HITPOINTS);
            int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
            int currentMaxPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
            if (!(statChanged.getSkill() == Skill.HITPOINTS && currentHp != localGimp.getHp() || statChanged.getSkill() == Skill.PRAYER && currentPrayer != localGimp.getPrayer())) {
                if (statChanged.getSkill() == Skill.HITPOINTS && currentMaxHp != localGimp.getMaxHp()) {
                    this.updateMaxHp(currentMaxHp);
                } else if (statChanged.getSkill() == Skill.PRAYER && currentMaxPrayer != localGimp.getMaxPrayer()) {
                    this.updateMaxPrayer(currentMaxPrayer);
                } else if (!(localGimp.getLastActivity() != null && activity.equals(localGimp.getLastActivity()) || statChanged.getSkill() == Skill.HITPOINTS)) {
                    this.updateLastActivity(activity);
                }
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        String CONFIG_GROUP = "gimp";
        String SERVER_ADDRESS_KEY = "serverAddress";
        String GHOST_MODE = "ghostMode";
        if (configChanged.getGroup().equals(CONFIG_GROUP) && configChanged.getKey().equals(SERVER_ADDRESS_KEY)) {
            if (this.gimBroadcastManager != null && this.gimBroadcastManager.isSocketConnected()) {
                log.debug("Server address changed, disconnecting socket client");
                this.gimBroadcastManager.disconnectSocketClient();
            }
        } else if (configChanged.getGroup().equals(CONFIG_GROUP) && configChanged.getKey().equals(GHOST_MODE)) {
            this.updateGhostMode(this.config.ghostMode());
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.client.isKeyPressed(81) || this.client.isMenuOpen() || this.group.getGimps().isEmpty() || !this.config.pings()) {
            return;
        }
        Tile selectedSceneTile = this.client.getSelectedSceneTile();
        if (selectedSceneTile == null) {
            return;
        }
        boolean isOnCanvas = false;
        for (MenuEntry menuEntry : this.client.getMenuEntries()) {
            if (menuEntry == null || !"walk here".equalsIgnoreCase(menuEntry.getOption())) continue;
            isOnCanvas = true;
        }
        if (!isOnCanvas) {
            return;
        }
        event.consume();
        TilePing tilePing = new TilePing(selectedSceneTile.getWorldLocation());
        Map<String, Object> tilePingData = this.group.getLocalGimp().getData();
        tilePingData.put("tilePing", tilePing);
        this.broadcastUpdate(tilePingData);
        this.onTilePing(this.group.getLocalGimp(), tilePing);
    }

    public void onTilePing(GimPlayer gimp, TilePing tilePing) {
        if (this.config.pings()) {
            Color color = gimp.getColor() != null ? gimp.getColor() : Color.RED;
            this.pendingTilePings.add(new PartyTilePingData(tilePing.getPoint(), color));
        }
        if (this.config.pingSound()) {
            WorldPoint point = tilePing.getPoint();
            if (point.getPlane() != this.client.getPlane() || !WorldPoint.isInScene((Client)this.client, (int)point.getX(), (int)point.getY())) {
                return;
            }
            this.clientThread.invoke(() -> this.client.playSoundEffect(3790));
        }
    }

    private void addPanel() {
        this.panel = (GimPluginPanel)((Object)this.injector.getInstance(GimPluginPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"gimpoint-small.png");
        int lowPriority = 15;
        this.navButton = NavigationButton.builder().tooltip("GIMP").icon(icon).priority(lowPriority).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    private void removePanel() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    private void startBroadcast() {
        if (this.gimBroadcastManager != null && this.gimBroadcastManager.isSocketConnected()) {
            this.gimBroadcastManager.disconnectSocketClient();
        }
        log.debug("Starting broadcast...");
        this.gimBroadcastManager = new GimBroadcastManager(this.group.getName(), this.okHttpClient, this.config, this.gson);
        this.gimBroadcastManager.connectSocketClient();
        this.setConnectionListeners(false);
        this.broadcastUpdate(this.group.getLocalGimp().getGimpData());
        this.pingForUpdate(true);
        this.listenForBroadcast();
        this.startIntervalTasks();
    }

    private void setConnectionListeners(boolean onReconnect) {
        Emitter.Listener onConnect = onReconnect ? this.onBroadcastReconnect : this.onBroadcastConnect;
        this.gimBroadcastManager.onBroadcastConnect(onConnect);
        this.gimBroadcastManager.onBroadcastConnectError(this.onBroadcastDisconnect);
        this.gimBroadcastManager.onBroadcastDisconnect(this.onBroadcastDisconnect);
    }

    private void listenForBroadcast() {
        this.gimBroadcastManager.listen(new Emitter.Listener(){

            @Override
            public void call(Object ... args) {
                JSONObject dataJson = (JSONObject)args[0];
                log.debug(dataJson.toString());
                GimPlayer gimpData = GimPlugin.this.gimBroadcastManager.parseBroadcastData(dataJson.toString());
                GimPlugin.this.handleUpdate(gimpData);
            }
        });
    }

    private void startIntervalTasks() {
        final Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != null) {
            long FIVE_SECONDS = 5000L;
            Task socketConnectTask = new Task(FIVE_SECONDS * 2L){

                @Override
                public void run() {
                    if (!GimPlugin.this.gimBroadcastManager.isSocketConnected()) {
                        GimPlugin.this.gimBroadcastManager.connectSocketClient();
                        GimPlugin.this.setConnectionListeners(true);
                    }
                }
            };
            Task locationBroadcastTask = new Task(FIVE_SECONDS){

                @Override
                public void run() {
                    GimPlayer localGimp = GimPlugin.this.group.getLocalGimp();
                    if (localGimp != null) {
                        GimLocation gimLocation = new GimLocation(localPlayer.getWorldLocation());
                        GimLocation lastLocation = localGimp.getLocation();
                        if (lastLocation != null && GimLocation.compare(lastLocation, gimLocation)) {
                            return;
                        }
                        GimPlugin.this.updateLocation(gimLocation);
                    }
                }

                @Override
                public long delay() {
                    if (GimPlugin.this.gimBroadcastManager.isSocketConnected()) {
                        return this.period / 2L;
                    }
                    return this.period;
                }
            };
            Task httpFallbackPingTask = new Task(FIVE_SECONDS * 2L){

                @Override
                public void run() {
                    if (!GimPlugin.this.gimBroadcastManager.isSocketConnected()) {
                        GimPlugin.this.pingForUpdate(false);
                    }
                }

                @Override
                public long delay() {
                    long nextDelay = this.period;
                    Widget worldMapView = GimPlugin.this.client.getWidget(38993927);
                    if (worldMapView != null) {
                        nextDelay /= 4L;
                    }
                    if (GimPlugin.this.gimBroadcastManager.isSocketConnected()) {
                        nextDelay /= 2L;
                    }
                    return nextDelay;
                }
            };
            Task tickMapPoints = new Task(300L){

                @Override
                public void run() {
                    GimPlugin.this.frameToggle = !GimPlugin.this.frameToggle;
                    for (GimPlayer gimp : GimPlugin.this.group.getGimps()) {
                        GimWorldMapPoint gimWorldMapPoint;
                        boolean moved;
                        if (gimp == null) continue;
                        GimPlugin.this.refreshMapPointVisibility(gimp);
                        if (!GimPlugin.this.gimWorldMapPointManager.hasPoint(gimp.getName()) || !(moved = (gimWorldMapPoint = GimPlugin.this.gimWorldMapPointManager.getPoint(gimp.getName())).moveTowardPlayer(GimPlugin.this.frameToggle))) continue;
                        gimWorldMapPoint.addFootstep(GimPlugin.this.gimWorldMapPointManager, GimPlugin.this.config.showFootsteps());
                    }
                }
            };
            this.taskManager.schedule(locationBroadcastTask, 0L);
            this.taskManager.schedule(httpFallbackPingTask, FIVE_SECONDS / 2L);
            this.taskManager.schedule(socketConnectTask, FIVE_SECONDS * 2L);
            this.taskManager.schedule(tickMapPoints, 0L);
        }
    }

    private void broadcastUpdate(Map<String, Object> gimpData) {
        this.gimBroadcastManager.broadcast(gimpData);
    }

    private void pingForUpdate(boolean initial) {
        this.gimBroadcastManager.ping().whenCompleteAsync((result, ex) -> {
            if (result != null) {
                for (GimPlayer gimp : this.group.getGimps()) {
                    GimPlayer gimpData = (GimPlayer)result.get(gimp.getName());
                    if (gimpData == null) continue;
                    if (gimp == this.group.getLocalGimp()) {
                        if (!initial) continue;
                        this.handleInitialLocalUpdate(gimpData);
                        continue;
                    }
                    this.handleUpdate(gimpData);
                }
            }
        });
    }

    private void stopBroadcast() {
        log.debug("Stopping broadcast...");
        this.taskManager.resetTasks();
        if (this.gimBroadcastManager != null) {
            this.gimBroadcastManager.stopListening();
            this.gimBroadcastManager.disconnectSocketClient();
        }
    }

    private void handleInitialLocalUpdate(GimPlayer gimpData) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            this.group.localHydrate(gimpData);
            this.onUpdate(gimpData);
        }
    }

    private void handleUpdate(GimPlayer gimpData) {
        this.group.update(gimpData);
        this.onUpdate(gimpData);
    }

    private void onUpdate(GimPlayer gimpData) {
        GimPlayer gimp;
        this.panel.updateGimpData(gimpData);
        if (gimpData.getNotes() != null) {
            this.panel.setNotes(gimpData.getName(), gimpData.getNotes());
        }
        if (gimpData.getTilePing() != null) {
            gimp = this.group.getGimp(gimpData.getName());
            this.onTilePing(gimp, gimpData.getTilePing());
        }
        if (gimpData.getGhostMode() != null && gimpData.getGhostMode().booleanValue()) {
            gimp = this.group.getGimp(gimpData.getName());
            this.updateWorld(gimp, 0);
        }
    }

    private void updateHp(int hp) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            localGimp.setHp(hp);
            this.panel.updateGimpData(localGimp);
            Map<String, Object> hpData = localGimp.getData();
            hpData.put("hp", hp);
            this.broadcastUpdate(hpData);
        }
    }

    private void updateMaxHp(int maxHp) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            localGimp.setMaxHp(maxHp);
            this.panel.updateGimpData(localGimp);
            Map<String, Object> hpData = localGimp.getData();
            hpData.put("maxHp", maxHp);
            this.broadcastUpdate(hpData);
        }
    }

    private void updatePrayer(int prayer) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            localGimp.setPrayer(prayer);
            this.panel.updateGimpData(localGimp);
            Map<String, Object> prayerData = localGimp.getData();
            prayerData.put("prayer", prayer);
            this.broadcastUpdate(prayerData);
        }
    }

    private void updateMaxPrayer(int maxPrayer) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            localGimp.setMaxPrayer(maxPrayer);
            this.panel.updateGimpData(localGimp);
            Map<String, Object> prayerData = localGimp.getData();
            prayerData.put("maxPrayer", maxPrayer);
            this.broadcastUpdate(prayerData);
        }
    }

    private void updateWorld(GimPlayer gimp, int world) {
        this.group.setWorld(gimp.getName(), world);
        this.panel.setWorld(gimp.getName(), world);
        this.panel.setLastActivity(gimp.getName(), gimp.getLastActivity(), world);
    }

    private void updateGhostMode(boolean ghostMode) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            this.group.setGhostMode(localGimp.getName(), ghostMode);
            Map<String, Object> ghostModeData = ghostMode ? localGimp.getData() : localGimp.getGimpData();
            ghostModeData.put("ghostMode", ghostMode);
            this.broadcastUpdate(ghostModeData);
        }
    }

    private void updateLocation(GimLocation gimLocation) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            this.group.setLocation(localGimp.getName(), gimLocation);
            this.panel.updateGimpData(localGimp);
            if (!this.config.ghostMode()) {
                Map<String, Object> data = localGimp.getData();
                data.put("location", gimLocation.getLocation());
                this.broadcastUpdate(data);
            }
        }
    }

    private void updateLastActivity(String activity) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            localGimp.setLastActivity(activity);
            this.panel.updateGimpData(localGimp);
            Map<String, Object> activityData = localGimp.getData();
            activityData.put("lastActivity", activity);
            this.broadcastUpdate(activityData);
        }
    }

    public void updateNotes(String notes) {
        GimPlayer localGimp = this.group.getLocalGimp();
        if (localGimp != null) {
            localGimp.setNotes(notes);
            this.config.notesData(notes);
            Map<String, Object> notesData = localGimp.getData();
            notesData.put("notes", notes);
            this.broadcastUpdate(notesData);
        }
    }

    private void refreshMapPointVisibility(GimPlayer gimp) {
        boolean shouldShow;
        String name = gimp.getName();
        boolean isLocalGimp = gimp == this.group.getLocalGimp();
        boolean bl = shouldShow = !(gimp.getLocation() == null || isLocalGimp && !this.config.showSelf() || !gimp.shouldIncludeLocation() && !isLocalGimp || gimp.getWorld() == 0);
        if (shouldShow && !this.gimWorldMapPointManager.hasPoint(name)) {
            this.gimWorldMapPointManager.addPoint(gimp);
        } else if (!shouldShow && this.gimWorldMapPointManager.hasPoint(name)) {
            this.gimWorldMapPointManager.removePoint(name);
        }
    }

    @Provides
    GimPluginConfig provideConfig(ConfigManager configManager) {
        return (GimPluginConfig)configManager.getConfig(GimPluginConfig.class);
    }

    public static void main(String[] args) throws Exception {
        ExternalPluginManager.loadBuiltin((Class[])new Class[]{GimPlugin.class});
        RuneLite.main((String[])args);
    }

    public Client getClient() {
        return this.client;
    }

    public GimPluginConfig getConfig() {
        return this.config;
    }

    public Group getGroup() {
        return this.group;
    }

    public List<PartyTilePingData> getPendingTilePings() {
        return this.pendingTilePings;
    }
}

