/*
 * Decompiled with CFR 0.152.
 */
package com.gimp;

import com.gimp.GimPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.party.data.PartyTilePingData;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class GimPingOverlay
extends Overlay {
    private final Client client;
    private final GimPlugin plugin;

    @Inject
    private GimPingOverlay(Client client, GimPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getGroup().isEmpty()) {
            return null;
        }
        List<PartyTilePingData> list = this.plugin.getPendingTilePings();
        synchronized (list) {
            Iterator<PartyTilePingData> iterator = this.plugin.getPendingTilePings().iterator();
            while (iterator.hasNext()) {
                PartyTilePingData next = iterator.next();
                if (next.getAlpha() <= 0) {
                    iterator.remove();
                    continue;
                }
                this.renderPing(graphics, next);
                next.setAlpha(next.getAlpha() - 5);
            }
        }
        return null;
    }

    private void renderPing(Graphics2D graphics, PartyTilePingData ping) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)ping.getPoint());
        if (localPoint == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint);
        if (poly == null) {
            return;
        }
        Color color = new Color(ping.getColor().getRed(), ping.getColor().getGreen(), ping.getColor().getBlue(), ping.getAlpha());
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
    }
}

