/*
 * Decompiled with CFR 0.152.
 */
package com.gimp;

import com.gimp.GimPluginConfig;
import com.gimp.gimps.GimPlayer;
import com.gimp.requests.HttpClient;
import com.gimp.requests.RequestClient;
import com.gimp.requests.SocketClient;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimBroadcastManager {
    private static final Logger log = LoggerFactory.getLogger(GimBroadcastManager.class);
    private static final Type pingDataTypeForJson = new TypeToken<Map<String, GimPlayer>>(){}.getType();
    private static final String EVENT_BROADCAST = "broadcast";
    private final HttpClient httpClient;
    private final SocketClient socketClient;
    private final Gson gson;

    public GimBroadcastManager(String groupName, OkHttpClient okHttpClient, GimPluginConfig config, Gson gson) {
        this.gson = gson;
        this.httpClient = new HttpClient(groupName, okHttpClient, config);
        this.socketClient = new SocketClient(groupName, config);
    }

    private Map<String, GimPlayer> parsePingData(String dataJson) {
        return (Map)this.gson.fromJson(dataJson, pingDataTypeForJson);
    }

    public GimPlayer parseBroadcastData(String dataJson) {
        return (GimPlayer)this.gson.fromJson(dataJson, GimPlayer.class);
    }

    public boolean isSocketConnected() {
        return this.socketClient.isConnected();
    }

    public void connectSocketClient() {
        this.socketClient.connect();
    }

    public void onBroadcastConnect(Emitter.Listener handleConnect) {
        Socket client = this.socketClient.getClient();
        if (client != null) {
            client.on("connect", handleConnect);
        }
    }

    public void onBroadcastDisconnect(Emitter.Listener handleDisconnect) {
        Socket client = this.socketClient.getClient();
        if (client != null) {
            client.on("disconnect", handleDisconnect);
        }
    }

    public void onBroadcastConnectError(Emitter.Listener handleError) {
        Socket client = this.socketClient.getClient();
        if (client != null) {
            client.on("connect_error", handleError);
        }
    }

    public void disconnectSocketClient() {
        this.socketClient.disconnect();
    }

    private RequestClient getRequestClient() {
        if (this.socketClient.isConnected()) {
            return this.socketClient;
        }
        return this.httpClient;
    }

    public void listen(Emitter.Listener handleBroadcast) {
        Socket client = this.socketClient.getClient();
        if (client != null) {
            client.on(EVENT_BROADCAST, handleBroadcast);
        }
    }

    public void stopListening() {
        Socket client = this.socketClient.getClient();
        if (client != null) {
            client.off(EVENT_BROADCAST);
        }
    }

    public void broadcast(Map<String, Object> data) {
        try {
            RequestClient requestClient = this.getRequestClient();
            String dataJson = this.gson.toJson(data);
            requestClient.broadcast(dataJson).thenAccept(result -> log.debug("Broadcast data: " + result));
        }
        catch (Exception e) {
            log.error("Broadcast error: " + e);
        }
    }

    public CompletableFuture<Map<String, GimPlayer>> ping() {
        RequestClient requestClient = this.getRequestClient();
        try {
            return requestClient.ping().thenApply(result -> {
                log.debug("Ping data: " + result);
                return this.parsePingData((String)result);
            });
        }
        catch (Exception e) {
            log.error("Ping error: " + e);
            return null;
        }
    }
}

