/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.panel;

import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.mistakestate.MistakeStateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import lombok.NonNull;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class PlayerMistakesBox
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private final MistakeStateManager mistakeStateManager;
    @NonNull
    private final String playerName;
    private int totalMistakes;
    private final JPanel mistakesContainer = new JPanel();
    private final JLabel raidCountLabel;
    private final JLabel mistakeCountLabel;

    protected PlayerMistakesBox(MistakeStateManager mistakeStateManager, @NonNull String playerName) {
        if (playerName == null) {
            throw new NullPointerException("playerName is marked non-null but is null");
        }
        this.mistakeStateManager = mistakeStateManager;
        this.playerName = playerName;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel playerMistakesTitle = new JPanel(new BorderLayout(5, 0));
        playerMistakesTitle.setBorder(new EmptyBorder(7, 7, 7, 7));
        playerMistakesTitle.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel playerNameLabel = new JLabel(playerName);
        playerNameLabel.setFont(FontManager.getRunescapeSmallFont());
        playerNameLabel.setForeground(Color.WHITE);
        playerMistakesTitle.add((Component)playerNameLabel, "West");
        this.mistakeCountLabel = new JLabel();
        this.mistakeCountLabel.setFont(FontManager.getRunescapeSmallFont());
        this.mistakeCountLabel.setForeground(Color.LIGHT_GRAY);
        this.mistakeCountLabel.setHorizontalAlignment(4);
        playerMistakesTitle.add((Component)this.mistakeCountLabel, "Center");
        this.raidCountLabel = new JLabel();
        this.raidCountLabel.setFont(FontManager.getRunescapeSmallFont());
        this.raidCountLabel.setForeground(Color.GRAY);
        playerMistakesTitle.add((Component)this.raidCountLabel, "East");
        this.add((Component)playerMistakesTitle, "North");
        this.add((Component)this.mistakesContainer, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setComponentPopupMenu(popupMenu);
    }

    void rebuildAllMistakes(boolean isRaidDeaths) {
        this.buildMistakes(isRaidDeaths);
        String mistakeString = this.totalMistakes == 1 ? "Mistake" : "Mistakes";
        this.mistakeCountLabel.setText(String.format("%s %s", this.totalMistakes, mistakeString));
        int totalRaids = this.mistakeStateManager.getRaidCountForPlayer(this.playerName);
        if (totalRaids > 0) {
            String raidString = totalRaids == 1 ? "Raid" : "Raids";
            this.raidCountLabel.setText(String.format("(%s %s)", totalRaids, raidString));
        }
        this.validate();
        this.repaint();
    }

    private void buildMistakes(boolean isRaidDeaths) {
        this.totalMistakes = 0;
        this.setVisible(true);
        ArrayList<ToaMistakeCount> mistakeCountsForPlayer = new ArrayList<ToaMistakeCount>();
        for (ToaMistake mistake : ToaMistake.values()) {
            int mistakeCount;
            if (isRaidDeaths && ToaMistake.isRoomDeath(mistake) || !isRaidDeaths && mistake == ToaMistake.DEATH || (mistakeCount = this.mistakeStateManager.getMistakeCountForPlayer(this.playerName, mistake)) <= 0) continue;
            this.totalMistakes += mistakeCount;
            mistakeCountsForPlayer.add(new ToaMistakeCount(mistake, mistakeCount));
        }
        int numRows = PlayerMistakesBox.calculateNumRows(mistakeCountsForPlayer.size());
        this.mistakesContainer.removeAll();
        this.mistakesContainer.setLayout(new GridLayout(numRows, 5, 1, 1));
        for (int i = 0; i < numRows * 5; ++i) {
            JPanel mistakeContainer = new JPanel(new BorderLayout(0, 0));
            mistakeContainer.setMaximumSize(new Dimension(36, 32));
            mistakeContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (i < mistakeCountsForPlayer.size()) {
                ToaMistakeCount mistakeCount = (ToaMistakeCount)mistakeCountsForPlayer.get(i);
                JLabel imageLabel = new JLabel();
                imageLabel.setLayout(new BorderLayout(0, 0));
                imageLabel.setToolTipText(mistakeCount.getTooltipText());
                imageLabel.setVerticalAlignment(0);
                imageLabel.setHorizontalAlignment(0);
                BufferedImage mistakeImage = mistakeCount.getMistake().getMistakeImage();
                imageLabel.setIcon(new ImageIcon(mistakeImage));
                JLabel quantityLabel = new JLabel();
                quantityLabel.setText(String.valueOf(mistakeCount.getCount()));
                quantityLabel.setFont(FontManager.getRunescapeSmallFont());
                quantityLabel.setForeground(Color.YELLOW);
                quantityLabel.setVerticalAlignment(3);
                quantityLabel.setHorizontalAlignment(2);
                imageLabel.add((Component)quantityLabel, "North");
                mistakeContainer.add(imageLabel);
            }
            this.mistakesContainer.add(mistakeContainer);
        }
        this.mistakesContainer.repaint();
    }

    private static int calculateNumRows(int numItems) {
        return (int)Math.ceil((double)numItems / 5.0);
    }

    @NonNull
    public String getPlayerName() {
        return this.playerName;
    }

    private static final class ToaMistakeCount {
        private final ToaMistake mistake;
        private final int count;
        private final String tooltipText;

        ToaMistakeCount(ToaMistake mistake, int count) {
            this.mistake = mistake;
            this.count = count;
            this.tooltipText = String.format("%s x %s", mistake.getMistakeName(), count);
        }

        public ToaMistake getMistake() {
            return this.mistake;
        }

        public int getCount() {
            return this.count;
        }

        public String getTooltipText() {
            return this.tooltipText;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToaMistakeCount)) {
                return false;
            }
            ToaMistakeCount other = (ToaMistakeCount)o;
            if (this.getCount() != other.getCount()) {
                return false;
            }
            ToaMistake this$mistake = this.getMistake();
            ToaMistake other$mistake = other.getMistake();
            if (this$mistake == null ? other$mistake != null : !((Object)((Object)this$mistake)).equals((Object)other$mistake)) {
                return false;
            }
            String this$tooltipText = this.getTooltipText();
            String other$tooltipText = other.getTooltipText();
            return !(this$tooltipText == null ? other$tooltipText != null : !this$tooltipText.equals(other$tooltipText));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            ToaMistake $mistake = this.getMistake();
            result = result * 59 + ($mistake == null ? 43 : ((Object)((Object)$mistake)).hashCode());
            String $tooltipText = this.getTooltipText();
            result = result * 59 + ($tooltipText == null ? 43 : $tooltipText.hashCode());
            return result;
        }

        public String toString() {
            return "PlayerMistakesBox.ToaMistakeCount(mistake=" + this.getMistake() + ", count=" + this.getCount() + ", tooltipText=" + this.getTooltipText() + ")";
        }
    }
}

