/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.mistakestate;

import com.toamistaketracker.ToaMistake;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class PlayerTrackingInfo {
    @NonNull
    private final String playerName;
    @NonNull
    private final Map<ToaMistake, Integer> mistakes;
    private int raidCount;

    public PlayerTrackingInfo(@NonNull String playerName) {
        if (playerName == null) {
            throw new NullPointerException("playerName is marked non-null but is null");
        }
        this.playerName = playerName;
        this.mistakes = new HashMap<ToaMistake, Integer>();
        this.raidCount = 1;
    }

    public void incrementMistake(ToaMistake mistake) {
        this.mistakes.compute(mistake, PlayerTrackingInfo::increment);
    }

    public void incrementRaidCount() {
        ++this.raidCount;
    }

    public boolean hasMistakes() {
        return !this.mistakes.isEmpty();
    }

    private static <T> Integer increment(T key, Integer oldValue) {
        return oldValue == null ? 1 : oldValue + 1;
    }

    @NonNull
    public String getPlayerName() {
        return this.playerName;
    }

    @NonNull
    public Map<ToaMistake, Integer> getMistakes() {
        return this.mistakes;
    }

    public int getRaidCount() {
        return this.raidCount;
    }
}

