/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.mistakestate;

import com.google.gson.Gson;
import com.toamistaketracker.mistakestate.MistakeStateManager;
import com.toamistaketracker.mistakestate.MistakeStateUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MistakeStateWriter {
    private static final Logger log = LoggerFactory.getLogger(MistakeStateWriter.class);
    private static final Gson GSON = RuneLiteAPI.GSON;
    private final Path mistakeStateDir = MistakeStateUtil.getMistakeStateDir();
    private final Path mistakeStateFilePath;

    @Inject
    public MistakeStateWriter(@Named(value="developerMode") boolean developerMode) {
        this.mistakeStateFilePath = MistakeStateUtil.getMistakeStateFilePath(developerMode);
    }

    public void write(MistakeStateManager mistakeStateManager) {
        try {
            Files.createDirectories(this.mistakeStateDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Unable to create directories " + this.mistakeStateDir, (Throwable)e);
            return;
        }
        Path filepath = this.mistakeStateFilePath;
        try (BufferedWriter writer = Files.newBufferedWriter(filepath, new OpenOption[0]);){
            writer.write(GSON.toJson((Object)mistakeStateManager));
        }
        catch (IOException e) {
            log.error("Unable to write mistake state to " + filepath, (Throwable)e);
        }
    }
}

