/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.mistakestate;

import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.mistakestate.PlayerTrackingInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class MistakeManager {
    private final Map<String, PlayerTrackingInfo> trackingInfo = new HashMap<String, PlayerTrackingInfo>();
    private int trackedRaids = 0;

    MistakeManager() {
    }

    public void clearAllMistakes() {
        this.trackingInfo.clear();
        this.trackedRaids = 0;
    }

    public void addMistakeForPlayer(String playerName, ToaMistake mistake) {
        PlayerTrackingInfo playerInfo = this.trackingInfo.computeIfAbsent(playerName, k -> new PlayerTrackingInfo(playerName));
        playerInfo.incrementMistake(mistake);
    }

    public void newRaid(Set<String> playerNames) {
        ++this.trackedRaids;
        for (String playerName : playerNames) {
            PlayerTrackingInfo playerInfo = this.trackingInfo.get(playerName);
            if (playerInfo != null) {
                playerInfo.incrementRaidCount();
                continue;
            }
            this.trackingInfo.put(playerName, new PlayerTrackingInfo(playerName));
        }
    }

    public void removeAllMistakesForPlayer(String playerName) {
        this.trackingInfo.remove(playerName);
    }

    public Set<String> getPlayersWithMistakes() {
        return this.trackingInfo.values().stream().filter(PlayerTrackingInfo::hasMistakes).map(PlayerTrackingInfo::getPlayerName).collect(Collectors.toSet());
    }

    public int getMistakeCountForPlayer(String playerName, ToaMistake mistake) {
        Integer count;
        PlayerTrackingInfo playerInfo = this.trackingInfo.get(playerName);
        if (playerInfo != null && (count = playerInfo.getMistakes().get((Object)mistake)) != null) {
            return count;
        }
        return 0;
    }

    public int getTotalMistakeCountForPlayer(String playerName) {
        int totalMistakes = 0;
        PlayerTrackingInfo playerInfo = this.trackingInfo.get(playerName);
        if (playerInfo != null) {
            for (int mistakes : playerInfo.getMistakes().values()) {
                totalMistakes += mistakes;
            }
        }
        return totalMistakes;
    }

    public int getTotalMistakeCountForAllPlayers() {
        int totalMistakes = 0;
        for (PlayerTrackingInfo playerInfo : this.trackingInfo.values()) {
            for (int mistakes : playerInfo.getMistakes().values()) {
                totalMistakes += mistakes;
            }
        }
        return totalMistakes;
    }

    public int getRaidCountForPlayer(String playerName) {
        PlayerTrackingInfo playerInfo = this.trackingInfo.get(playerName);
        if (playerInfo != null) {
            return playerInfo.getRaidCount();
        }
        return 0;
    }

    public int getTrackedRaids() {
        return this.trackedRaids;
    }
}

