/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.tracker;

import com.toamistaketracker.Raider;
import com.toamistaketracker.detector.tracker.BaseRaidTracker;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VengeanceTracker
extends BaseRaidTracker {
    private static final Logger log = LoggerFactory.getLogger(VengeanceTracker.class);
    public static final String VENGEANCE_TEXT = "Taste vengeance!";
    private final Set<String> raidersVengeance = new HashSet<String>();
    private final Set<String> raidersChatVengeance = new HashSet<String>();

    @Override
    public void cleanup() {
        this.raidersVengeance.clear();
        this.raidersChatVengeance.clear();
    }

    @Override
    public void afterDetect() {
        this.cleanup();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.raidersVengeance.removeAll(this.raidersChatVengeance);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == 2450 && event.getValue() == 0 && this.client.getLocalPlayer() != null && this.raidState.isRaider((Actor)this.client.getLocalPlayer())) {
            this.raidersVengeance.add(this.client.getLocalPlayer().getName());
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player) || event.getActor().getName() == null) {
            return;
        }
        String name = Text.sanitize((String)event.getActor().getName());
        if (this.isOtherVengeance(name, event.getOverheadText())) {
            this.raidersVengeance.add(name);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.PUBLICCHAT) {
            return;
        }
        String name = Text.sanitize((String)event.getName());
        if (this.isOtherVengeance(name, event.getMessage())) {
            this.raidersChatVengeance.add(name);
        }
    }

    public boolean didPopVengeance(Raider raider) {
        return this.raidersVengeance.contains(raider.getName());
    }

    private boolean isOtherVengeance(String name, String message) {
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null && this.client.getLocalPlayer().getName().equals(name)) {
            return false;
        }
        return VENGEANCE_TEXT.equals(message);
    }

    public Set<String> getRaidersVengeance() {
        return this.raidersVengeance;
    }
}

