/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.tracker;

import com.toamistaketracker.Raider;
import com.toamistaketracker.detector.tracker.DelayedObjectsTracker;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import net.runelite.api.HeadIcon;
import net.runelite.api.Projectile;
import net.runelite.api.events.ProjectileMoved;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverheadTracker
extends DelayedObjectsTracker<Projectile> {
    private static final Logger log = LoggerFactory.getLogger(OverheadTracker.class);
    private final Map<Integer, HeadIcon> attacks;
    private final Set<Projectile> trackedProjectiles = new HashSet<Projectile>();

    public void trackProjectile(@NonNull ProjectileMoved event, @NonNull Integer activationTick) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (activationTick == null) {
            throw new NullPointerException("activationTick is marked non-null but is null");
        }
        Projectile projectile = event.getProjectile();
        if (!this.attacks.containsKey(projectile.getId()) || this.trackedProjectiles.contains(projectile)) {
            return;
        }
        if (!this.hasEnoughRemainingCycles(projectile)) {
            return;
        }
        this.put(activationTick, projectile);
        this.trackedProjectiles.add(projectile);
    }

    @Override
    public void onGameTick(@NonNull Integer gameTick) {
        if (gameTick == null) {
            throw new NullPointerException("gameTick is marked non-null but is null");
        }
        super.onGameTick(gameTick);
        this.trackedProjectiles.removeIf(projectile -> !this.hasEnoughRemainingCycles((Projectile)projectile));
    }

    @Override
    public void clear() {
        super.clear();
        this.trackedProjectiles.clear();
    }

    public Set<Projectile> getActiveProjectiles() {
        return this.getActiveObjects();
    }

    public boolean didMissPrayer(Raider raider) {
        if (this.getActiveProjectiles().isEmpty()) {
            return false;
        }
        HeadIcon playerHeadIcon = raider.getPlayer().getOverheadIcon();
        if (playerHeadIcon == null) {
            return true;
        }
        Projectile activeProjectile = this.getActiveProjectileForRaider(raider);
        if (activeProjectile == null) {
            return false;
        }
        HeadIcon requiredHeadIcon = this.attacks.get(activeProjectile.getId());
        if (requiredHeadIcon == null) {
            return false;
        }
        return playerHeadIcon != requiredHeadIcon;
    }

    public Projectile getActiveProjectileForRaider(Raider raider) {
        for (Projectile projectile : this.getActiveProjectiles()) {
            if (projectile == null || !raider.getPlayer().equals(projectile.getInteracting())) continue;
            return projectile;
        }
        return null;
    }

    private boolean hasEnoughRemainingCycles(Projectile projectile) {
        return projectile.getRemainingCycles() > 30;
    }

    public OverheadTracker(Map<Integer, HeadIcon> attacks) {
        this.attacks = attacks;
    }
}

