/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.tracker;

import com.toamistaketracker.detector.tracker.ObjectsTracker;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantObjectsTracker<T>
implements ObjectsTracker<T> {
    private static final Logger log = LoggerFactory.getLogger(InstantObjectsTracker.class);
    private final Set<T> activeObjects = new HashSet<T>();
    private final Set<T> newObjects = new HashSet<T>();

    public void add(@NonNull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.newObjects.add(object);
    }

    @Override
    public void onGameTick(@NonNull Integer gameTick) {
        if (gameTick == null) {
            throw new NullPointerException("gameTick is marked non-null but is null");
        }
        this.activeObjects.clear();
        this.activeObjects.addAll(this.newObjects);
        this.newObjects.clear();
    }

    @Override
    public Set<T> getActiveObjects() {
        return this.activeObjects;
    }

    @Override
    public void clear() {
        this.activeObjects.clear();
        this.newObjects.clear();
    }
}

