/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.tracker;

import com.google.common.annotations.VisibleForTesting;
import com.toamistaketracker.detector.tracker.ObjectsTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedObjectsTracker<T>
implements ObjectsTracker<T> {
    private static final Logger log = LoggerFactory.getLogger(DelayedObjectsTracker.class);
    protected final Set<T> activeObjects = new HashSet<T>();
    @VisibleForTesting
    protected final Map<Integer, Set<T>> delayedObjects = new HashMap<Integer, Set<T>>();

    public void put(@NonNull Integer activationTick, @NonNull T object) {
        if (activationTick == null) {
            throw new NullPointerException("activationTick is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.delayedObjects.computeIfAbsent(activationTick, k -> new HashSet()).add(object);
    }

    public void putAll(@NonNull Integer activationTick, @NonNull Set<T> objects) {
        if (activationTick == null) {
            throw new NullPointerException("activationTick is marked non-null but is null");
        }
        if (objects == null) {
            throw new NullPointerException("objects is marked non-null but is null");
        }
        this.delayedObjects.computeIfAbsent(activationTick, k -> new HashSet()).addAll(objects);
    }

    @Override
    public void onGameTick(@NonNull Integer gameTick) {
        if (gameTick == null) {
            throw new NullPointerException("gameTick is marked non-null but is null");
        }
        this.activeObjects.clear();
        if (this.delayedObjects.containsKey(gameTick)) {
            this.activeObjects.addAll((Collection)this.delayedObjects.remove(gameTick));
        }
    }

    @Override
    public Set<T> getActiveObjects() {
        return this.activeObjects;
    }

    @Override
    public void clear() {
        this.activeObjects.clear();
        this.delayedObjects.clear();
    }

    public Map<Integer, Set<T>> getDelayedObjects() {
        return this.delayedObjects;
    }
}

