/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.tracker;

import com.toamistaketracker.ToaMistake;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedMistakeTracker {
    private final Logger log = LoggerFactory.getLogger(DelayedMistakeTracker.class);
    private final Map<String, List<DelayedMistake>> delayedMistakes = new HashMap<String, List<DelayedMistake>>();

    public void addDelayedMistake(@NonNull String raiderName, @NonNull ToaMistake mistake, @NonNull Integer currentTick, Integer tickDelay) {
        if (raiderName == null) {
            throw new NullPointerException("raiderName is marked non-null but is null");
        }
        if (mistake == null) {
            throw new NullPointerException("mistake is marked non-null but is null");
        }
        if (currentTick == null) {
            throw new NullPointerException("currentTick is marked non-null but is null");
        }
        this.delayedMistakes.computeIfAbsent(raiderName, k -> new ArrayList()).add(DelayedMistake.builder().raiderName(raiderName).mistake(mistake).tickAdded(currentTick).tickDelay(tickDelay).build());
    }

    public List<ToaMistake> popDelayedMistakes(@NonNull String raiderName, @NonNull Integer currentTick) {
        if (raiderName == null) {
            throw new NullPointerException("raiderName is marked non-null but is null");
        }
        if (currentTick == null) {
            throw new NullPointerException("currentTick is marked non-null but is null");
        }
        if (this.delayedMistakes.get(raiderName) == null) {
            return Collections.emptyList();
        }
        ArrayList<DelayedMistake> foundMistakes = new ArrayList<DelayedMistake>();
        for (DelayedMistake delayedMistake : this.delayedMistakes.get(raiderName)) {
            int ticksSince = currentTick - delayedMistake.getTickAdded();
            if (ticksSince < delayedMistake.getTickDelay()) continue;
            foundMistakes.add(delayedMistake);
        }
        this.delayedMistakes.get(raiderName).removeAll(foundMistakes);
        return foundMistakes.stream().map(DelayedMistake::getMistake).collect(Collectors.toList());
    }

    public List<ToaMistake> popAllDelayedMistakes(@NonNull String raiderName) {
        if (raiderName == null) {
            throw new NullPointerException("raiderName is marked non-null but is null");
        }
        if (this.delayedMistakes.get(raiderName) == null) {
            return Collections.emptyList();
        }
        List<ToaMistake> mistakes = this.delayedMistakes.get(raiderName).stream().map(DelayedMistake::getMistake).collect(Collectors.toList());
        this.delayedMistakes.get(raiderName).clear();
        return mistakes;
    }

    public void clear() {
        this.delayedMistakes.clear();
    }

    private static final class DelayedMistake {
        @NonNull
        private final String raiderName;
        @NonNull
        private final ToaMistake mistake;
        @NonNull
        private final Integer tickAdded;
        private final Integer tickDelay;

        DelayedMistake(@NonNull String raiderName, @NonNull ToaMistake mistake, @NonNull Integer tickAdded, Integer tickDelay) {
            if (raiderName == null) {
                throw new NullPointerException("raiderName is marked non-null but is null");
            }
            if (mistake == null) {
                throw new NullPointerException("mistake is marked non-null but is null");
            }
            if (tickAdded == null) {
                throw new NullPointerException("tickAdded is marked non-null but is null");
            }
            this.raiderName = raiderName;
            this.mistake = mistake;
            this.tickAdded = tickAdded;
            this.tickDelay = tickDelay;
        }

        public static DelayedMistakeBuilder builder() {
            return new DelayedMistakeBuilder();
        }

        @NonNull
        public String getRaiderName() {
            return this.raiderName;
        }

        @NonNull
        public ToaMistake getMistake() {
            return this.mistake;
        }

        @NonNull
        public Integer getTickAdded() {
            return this.tickAdded;
        }

        public Integer getTickDelay() {
            return this.tickDelay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DelayedMistake)) {
                return false;
            }
            DelayedMistake other = (DelayedMistake)o;
            Integer this$tickAdded = this.getTickAdded();
            Integer other$tickAdded = other.getTickAdded();
            if (this$tickAdded == null ? other$tickAdded != null : !((Object)this$tickAdded).equals(other$tickAdded)) {
                return false;
            }
            Integer this$tickDelay = this.getTickDelay();
            Integer other$tickDelay = other.getTickDelay();
            if (this$tickDelay == null ? other$tickDelay != null : !((Object)this$tickDelay).equals(other$tickDelay)) {
                return false;
            }
            String this$raiderName = this.getRaiderName();
            String other$raiderName = other.getRaiderName();
            if (this$raiderName == null ? other$raiderName != null : !this$raiderName.equals(other$raiderName)) {
                return false;
            }
            ToaMistake this$mistake = this.getMistake();
            ToaMistake other$mistake = other.getMistake();
            return !(this$mistake == null ? other$mistake != null : !((Object)((Object)this$mistake)).equals((Object)other$mistake));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $tickAdded = this.getTickAdded();
            result = result * 59 + ($tickAdded == null ? 43 : ((Object)$tickAdded).hashCode());
            Integer $tickDelay = this.getTickDelay();
            result = result * 59 + ($tickDelay == null ? 43 : ((Object)$tickDelay).hashCode());
            String $raiderName = this.getRaiderName();
            result = result * 59 + ($raiderName == null ? 43 : $raiderName.hashCode());
            ToaMistake $mistake = this.getMistake();
            result = result * 59 + ($mistake == null ? 43 : ((Object)((Object)$mistake)).hashCode());
            return result;
        }

        public String toString() {
            return "DelayedMistakeTracker.DelayedMistake(raiderName=" + this.getRaiderName() + ", mistake=" + this.getMistake() + ", tickAdded=" + this.getTickAdded() + ", tickDelay=" + this.getTickDelay() + ")";
        }

        public static class DelayedMistakeBuilder {
            private String raiderName;
            private ToaMistake mistake;
            private Integer tickAdded;
            private Integer tickDelay;

            DelayedMistakeBuilder() {
            }

            public DelayedMistakeBuilder raiderName(@NonNull String raiderName) {
                if (raiderName == null) {
                    throw new NullPointerException("raiderName is marked non-null but is null");
                }
                this.raiderName = raiderName;
                return this;
            }

            public DelayedMistakeBuilder mistake(@NonNull ToaMistake mistake) {
                if (mistake == null) {
                    throw new NullPointerException("mistake is marked non-null but is null");
                }
                this.mistake = mistake;
                return this;
            }

            public DelayedMistakeBuilder tickAdded(@NonNull Integer tickAdded) {
                if (tickAdded == null) {
                    throw new NullPointerException("tickAdded is marked non-null but is null");
                }
                this.tickAdded = tickAdded;
                return this;
            }

            public DelayedMistakeBuilder tickDelay(Integer tickDelay) {
                this.tickDelay = tickDelay;
                return this;
            }

            public DelayedMistake build() {
                return new DelayedMistake(this.raiderName, this.mistake, this.tickAdded, this.tickDelay);
            }

            public String toString() {
                return "DelayedMistakeTracker.DelayedMistake.DelayedMistakeBuilder(raiderName=" + this.raiderName + ", mistake=" + this.mistake + ", tickAdded=" + this.tickAdded + ", tickDelay=" + this.tickDelay + ")";
            }
        }
    }
}

