/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.tracker;

import com.toamistaketracker.RaidState;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRaidTracker {
    private static final Logger log = LoggerFactory.getLogger(BaseRaidTracker.class);
    @Inject
    protected Client client;
    @Inject
    protected EventBus eventBus;
    @Inject
    protected RaidState raidState;

    public void startup() {
        this.cleanup();
        log.debug("Starting tracker");
        this.eventBus.register((Object)this);
    }

    public void shutdown() {
        log.debug("Shutting down tracker");
        this.eventBus.unregister((Object)this);
        this.cleanup();
    }

    public abstract void afterDetect();

    public abstract void cleanup();
}

