/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.puzzle;

import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.tracker.AppliedHitsplatsTracker;
import com.toamistaketracker.detector.tracker.DelayedMistakeTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HetPuzzleDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(HetPuzzleDetector.class);
    private static final Set<Integer> LIGHT_BEAM_GRAPHICS_IDS = ImmutableSet.of((Object)2064, (Object)2114);
    private static final int ORB_OF_DARKNESS_GRAPHICS_ID = 379;
    private final Set<WorldPoint> orbHitTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> lightHitTiles = new HashSet<WorldPoint>();
    private final AppliedHitsplatsTracker appliedHitsplats = new AppliedHitsplatsTracker();
    private final DelayedMistakeTracker delayedMistakes = new DelayedMistakeTracker();

    @Override
    public void cleanup() {
        this.orbHitTiles.clear();
        this.lightHitTiles.clear();
        this.appliedHitsplats.clear();
        this.delayedMistakes.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.HET_PUZZLE;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.orbHitTiles.contains(raider.getPreviousWorldLocation()) && this.appliedHitsplats.popHitsplatApplied(raider.getName())) {
            mistakes.add(ToaMistake.HET_PUZZLE_DARK_ORB);
        }
        if (this.lightHitTiles.contains(raider.getPreviousWorldLocation())) {
            this.delayedMistakes.addDelayedMistake(raider.getName(), ToaMistake.HET_PUZZLE_LIGHT, this.client.getTickCount(), 1);
        }
        mistakes.addAll(this.delayedMistakes.popDelayedMistakes(raider.getName(), this.client.getTickCount()));
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.orbHitTiles.clear();
        this.lightHitTiles.clear();
        this.appliedHitsplats.clear();
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        if (event.getGraphicsObject().getId() == 379) {
            this.orbHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
        } else if (LIGHT_BEAM_GRAPHICS_IDS.contains(event.getGraphicsObject().getId())) {
            this.lightHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (this.raidState.isRaider(event.getActor())) {
            this.appliedHitsplats.addHitsplatForRaider(event.getActor().getName());
        }
    }
}

