/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.puzzle;

import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CrondisPuzzleDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(CrondisPuzzleDetector.class);
    private static final Set<WorldPoint> WATERFALL_REGION_TILES = ImmutableSet.of((Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)23, (int)7, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)24, (int)7, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)26, (int)7, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)27, (int)7, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)37, (int)7, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)38, (int)7, (int)0), (Object[])new WorldPoint[]{WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)40, (int)7, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)41, (int)7, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)23, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)24, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)26, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)27, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)37, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)38, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)40, (int)57, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)41, (int)57, (int)0)});
    private static final Set<WorldPoint> PALM_TREE_REGION_TILES = ImmutableSet.of((Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)30, (int)29, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)31, (int)29, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)32, (int)29, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)33, (int)29, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)34, (int)29, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)35, (int)30, (int)0), (Object[])new WorldPoint[]{WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)35, (int)31, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)35, (int)32, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)35, (int)33, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)35, (int)34, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)30, (int)35, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)31, (int)35, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)32, (int)35, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)33, (int)35, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)34, (int)35, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)29, (int)30, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)29, (int)31, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)29, (int)32, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)29, (int)33, (int)0), WorldPoint.fromRegion((int)RaidRoom.CRONDIS_PUZZLE.getRegionId(), (int)29, (int)34, (int)0)});
    private static final String PALM_TREE_NAME = "Palm of Resourcefulness";
    private static final int PLAYER_WATER_ANIMATION_ID = 827;
    private static final int WATER_HITSPLAT_UP_ID = 11;
    private static final int WATER_HITSPLAT_DOWN_ID = 15;
    private static final int MAX_WATER_HITSPLAT_UP_AMOUNT = 100;
    private Set<WorldPoint> waterFallTiles = new HashSet<WorldPoint>();
    private Set<WorldPoint> palmTreeTiles = new HashSet<WorldPoint>();
    private final Set<String> raidersAnimatingWater = new HashSet<String>();
    private final Set<String> raidersWithWater = new HashSet<String>();
    private final Set<String> raidersLostWater = new HashSet<String>();
    private final Set<String> raidersWatering = new HashSet<String>();
    private int lowWaterHitsplats;

    @Override
    public void startup() {
        super.startup();
        this.computeTiles();
    }

    @Override
    public void cleanup() {
        this.waterFallTiles.clear();
        this.palmTreeTiles.clear();
        this.raidersAnimatingWater.clear();
        this.raidersWithWater.clear();
        this.raidersLostWater.clear();
        this.raidersWatering.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.CRONDIS_PUZZLE;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        if (this.raidersAnimatingWater.contains(raider.getName())) {
            this.computeRaiderWatering(raider);
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.raidersWatering.contains(raider.getName())) {
            if (this.lowWaterHitsplats > 0 && this.raidersLostWater.contains(raider.getName())) {
                mistakes.add(ToaMistake.CRONDIS_PUZZLE_LOW_WATER);
                --this.lowWaterHitsplats;
            }
            this.raidersWithWater.remove(raider.getName());
            this.raidersLostWater.remove(raider.getName());
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.raidersAnimatingWater.clear();
        this.raidersWatering.clear();
        this.lowWaterHitsplats = 0;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (this.raidState.isRaider(event.getActor()) && this.raidersWithWater.contains(name) && this.isDamageHitsplat(event.getHitsplat().getHitsplatType())) {
            this.raidersLostWater.add(name);
        } else if (event.getActor() instanceof NPC && PALM_TREE_NAME.equals(name) && event.getHitsplat().getHitsplatType() == 11 && event.getHitsplat().getAmount() < 100) {
            ++this.lowWaterHitsplats;
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!(event.getActor() instanceof Player) || event.getActor().getAnimation() != 827 || !this.raidState.isRaider(event.getActor())) {
            return;
        }
        this.raidersAnimatingWater.add(event.getActor().getName());
    }

    private boolean isDamageHitsplat(int hitsplatType) {
        return hitsplatType == 16 || hitsplatType == 17;
    }

    private void computeTiles() {
        WorldPoint wpPlayer = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint lpPlayer = LocalPoint.fromWorld((Client)this.client, (WorldPoint)wpPlayer);
        if (lpPlayer == null) {
            return;
        }
        int dx = lpPlayer.getSceneX() - wpPlayer.getRegionX();
        int dy = lpPlayer.getSceneY() - wpPlayer.getRegionY();
        this.waterFallTiles = WATERFALL_REGION_TILES.stream().map(wp -> WorldPoint.fromScene((Client)this.client, (int)(wp.getRegionX() + dx), (int)(wp.getRegionY() + dy), (int)wp.getPlane())).collect(Collectors.toSet());
        this.palmTreeTiles = PALM_TREE_REGION_TILES.stream().map(wp -> WorldPoint.fromScene((Client)this.client, (int)(wp.getRegionX() + dx), (int)(wp.getRegionY() + dy), (int)wp.getPlane())).collect(Collectors.toSet());
    }

    private void computeRaiderWatering(Raider raider) {
        if (this.waterFallTiles.contains(raider.getCurrentWorldLocation())) {
            this.raidersWithWater.add(raider.getName());
            this.raidersLostWater.remove(raider.getName());
        } else if (this.palmTreeTiles.contains(raider.getCurrentWorldLocation())) {
            this.raidersWatering.add(raider.getName());
        }
    }

    public Set<WorldPoint> getWaterFallTiles() {
        return this.waterFallTiles;
    }

    public Set<WorldPoint> getPalmTreeTiles() {
        return this.palmTreeTiles;
    }
}

