/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.puzzle;

import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApmekenPuzzleDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(ApmekenPuzzleDetector.class);
    private static final int VENT_GRAPHICS_ID = 2138;
    private static final int PILLAR_GRAPHICS_ID = 2139;
    private static final int VENOM_TILE_GAME_OBJECT_ID = 45493;
    private static final int VOLATILE_GRAPHICS_ID = 131;
    private static final String VENT_FAILURE_MESSAGE = "The fumes filling the room suddenly ignite!";
    private static final String PILLAR_FAILURE_MESSAGE = "Damaged roof supports cause some debris to fall on you!";
    private static final String CORRUPTION_FAILURE_MESSAGE = "Your group is overwhelmed by Amascut's corruption!";
    private ToaMistake teamMistake;
    private final Set<WorldPoint> venomTilesToSpawn = new HashSet<WorldPoint>();
    private final Set<WorldPoint> venomTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> volatileHitTiles = new HashSet<WorldPoint>();

    @Override
    public void cleanup() {
        this.teamMistake = null;
        this.venomTilesToSpawn.clear();
        this.venomTiles.clear();
        this.volatileHitTiles.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.APMEKEN_PUZZLE;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.teamMistake != null) {
            mistakes.add(this.teamMistake);
        }
        if (this.venomTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.APMEKEN_PUZZLE_VENOM);
        }
        if (this.volatileHitTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.APMEKEN_PUZZLE_VOLATILE);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.teamMistake = null;
        this.volatileHitTiles.clear();
        this.venomTiles.addAll(this.venomTilesToSpawn);
        this.venomTilesToSpawn.clear();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        if (VENT_FAILURE_MESSAGE.equals(message)) {
            this.teamMistake = ToaMistake.APMEKEN_PUZZLE_VENT;
        } else if (PILLAR_FAILURE_MESSAGE.equals(message)) {
            this.teamMistake = ToaMistake.APMEKEN_PUZZLE_PILLAR;
        } else if (CORRUPTION_FAILURE_MESSAGE.equals(message)) {
            this.teamMistake = ToaMistake.APMEKEN_PUZZLE_CORRUPTION;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (event.getGameObject().getId() == 45493) {
            this.venomTilesToSpawn.add(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (event.getGameObject().getId() == 45493) {
            this.venomTilesToSpawn.remove(event.getGameObject().getWorldLocation());
            this.venomTiles.remove(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        if (event.getGraphicsObject().getId() != 131) {
            return;
        }
        Set<WorldPoint> newHitTiles = this.compute3By3TilesFromCenter(this.getWorldPoint(event.getGraphicsObject()));
        this.volatileHitTiles.addAll(newHitTiles);
    }

    public Set<WorldPoint> getVolatileHitTiles() {
        return this.volatileHitTiles;
    }
}

