/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.death;

import com.google.common.collect.ImmutableMap;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeathDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(DeathDetector.class);
    private static final Map<RaidRoom, ToaMistake> ROOM_DEATHS = ImmutableMap.builder().put((Object)RaidRoom.HET_PUZZLE, (Object)ToaMistake.DEATH_HET).put((Object)RaidRoom.AKKHA, (Object)ToaMistake.DEATH_HET).put((Object)RaidRoom.CRONDIS_PUZZLE, (Object)ToaMistake.DEATH_CRONDIS).put((Object)RaidRoom.ZEBAK, (Object)ToaMistake.DEATH_CRONDIS).put((Object)RaidRoom.SCABARAS_PUZZLE, (Object)ToaMistake.DEATH_SCABARAS).put((Object)RaidRoom.KEPHRI, (Object)ToaMistake.DEATH_SCABARAS).put((Object)RaidRoom.APMEKEN_PUZZLE, (Object)ToaMistake.DEATH_APMEKEN).put((Object)RaidRoom.BABA, (Object)ToaMistake.DEATH_APMEKEN).put((Object)RaidRoom.WARDENS_P1_P2, (Object)ToaMistake.DEATH_WARDENS).put((Object)RaidRoom.WARDENS_P3, (Object)ToaMistake.DEATH_WARDENS).build();
    private final Set<String> raiderDeaths = new HashSet<String>();

    @Override
    public void cleanup() {
        this.raiderDeaths.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return null;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.raiderDeaths.contains(raider.getName())) {
            mistakes.add(ToaMistake.DEATH);
            if (!ROOM_DEATHS.containsKey((Object)this.raidState.getCurrentRoom())) {
                log.error("Unknown room death: {}", (Object)this.raidState.getCurrentRoom());
                return Collections.emptyList();
            }
            mistakes.add(ROOM_DEATHS.get((Object)this.raidState.getCurrentRoom()));
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.raiderDeaths.clear();
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        if (this.raidState.isRaider(event.getActor())) {
            this.raiderDeaths.add(event.getActor().getName());
        }
    }
}

