/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.boss;

import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.PlayerChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZebakDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(ZebakDetector.class);
    private static final int CHOMP_ANIMATION_ID = 9620;
    private static final int CHOMP_HIT_DELAY_IN_TICKS = 2;
    private static final Set<Integer> SWIMMING_POSE_IDS = ImmutableSet.of((Object)772, (Object)773);
    private static final Set<Integer> ACID_TILE_GAME_OBJECT_IDS = ImmutableSet.of((Object)45570, (Object)45571, (Object)45572, (Object)45573, (Object)45574, (Object)45575, (Object[])new Integer[]{45576});
    private static final int EARTHQUAKE_GRAPHICS_ID = 2184;
    private static final int ZEBAK_SCREAM_ANIMATION_ID = 9628;
    private static final String ZEBAK_NAME = "Zebak";
    private static final String WAVE_NAME = "Wave";
    private static final String BLOOD_CLOUD_NAME = "Blood Cloud";
    private final Set<WorldPoint> acidTilesToSpawn = new HashSet<WorldPoint>();
    private final Set<WorldPoint> acidTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> bloodHealedTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> earthquakeHitTiles = new HashSet<WorldPoint>();
    private final Set<String> raidersCurrentlySwimming = new HashSet<String>();
    private final Set<String> raidersPreviouslySwimming = new HashSet<String>();
    private final List<NPC> waves = new ArrayList<NPC>();
    private boolean isZebakScreaming = false;

    @Override
    public void cleanup() {
        this.acidTilesToSpawn.clear();
        this.acidTiles.clear();
        this.bloodHealedTiles.clear();
        this.earthquakeHitTiles.clear();
        this.raidersCurrentlySwimming.clear();
        this.raidersPreviouslySwimming.clear();
        this.waves.clear();
        this.isZebakScreaming = false;
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.ZEBAK;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.acidTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.ZEBAK_ACID_TILE);
        }
        if (this.bloodHealedTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.ZEBAK_BLOOD_CLOUD);
        }
        if (this.isEarthquakeHit(raider)) {
            mistakes.add(ToaMistake.ZEBAK_EARTHQUAKE);
        }
        if (this.isWaveHit(raider)) {
            mistakes.add(ToaMistake.ZEBAK_WAVE);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.acidTiles.addAll(this.acidTilesToSpawn);
        this.acidTilesToSpawn.clear();
        this.bloodHealedTiles.clear();
        this.earthquakeHitTiles.clear();
        this.raidersPreviouslySwimming.clear();
        this.raidersPreviouslySwimming.addAll(this.raidersCurrentlySwimming);
        this.raidersCurrentlySwimming.clear();
    }

    private boolean isEarthquakeHit(Raider raider) {
        return this.earthquakeHitTiles.contains(raider.getPreviousWorldLocation()) && this.isZebakScreaming;
    }

    private boolean isWaveHit(Raider raider) {
        if (raider.getPreviousWorldLocation() == null || this.waves.isEmpty() || this.raidersPreviouslySwimming.contains(raider.getName())) {
            return false;
        }
        return Math.abs(raider.getCurrentWorldLocation().getY() - raider.getPreviousWorldLocation().getY()) > 2;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (ACID_TILE_GAME_OBJECT_IDS.contains(event.getGameObject().getId())) {
            this.acidTilesToSpawn.add(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (ACID_TILE_GAME_OBJECT_IDS.contains(event.getGameObject().getId())) {
            this.acidTilesToSpawn.remove(event.getGameObject().getWorldLocation());
            this.acidTiles.remove(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (event.getActor().getName() != null && BLOOD_CLOUD_NAME.equals(event.getActor().getName()) && event.getHitsplat().getHitsplatType() == 6) {
            this.bloodHealedTiles.add(event.getActor().getWorldLocation());
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        if (event.getGraphicsObject().getId() == 2184) {
            this.earthquakeHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getNpc().getName());
        if (WAVE_NAME.equals(name)) {
            this.waves.add(event.getNpc());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getNpc().getName());
        if (WAVE_NAME.equals(name)) {
            this.waves.remove(event.getNpc());
        }
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged event) {
        if (event.getPlayer() != null && SWIMMING_POSE_IDS.contains(event.getPlayer().getPoseAnimation())) {
            this.raidersCurrentlySwimming.add(event.getPlayer().getName());
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() == null || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (event.getActor() instanceof NPC && ZEBAK_NAME.equals(name)) {
            this.isZebakScreaming = event.getActor().getAnimation() == 9628;
        }
    }
}

