/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.boss;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.tracker.DelayedHitTilesTracker;
import com.toamistaketracker.detector.tracker.DelayedMistakeTracker;
import com.toamistaketracker.detector.tracker.InstantHitTilesTracker;
import com.toamistaketracker.detector.tracker.OverheadTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.HeadIcon;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WardensP3Detector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(WardensP3Detector.class);
    private final Set<Integer> EARTHQUAKE_GRAPHICS_IDS = ImmutableSet.of((Object)2220, (Object)2221, (Object)2222, (Object)2223);
    private final Set<Integer> KEPHRI_BOMB_GRAPHICS_IDS = ImmutableSet.of((Object)2156, (Object)2157, (Object)2158, (Object)2159);
    private static final Map<Integer, HeadIcon> AKKHA_ATTACKS = ImmutableMap.of((Object)2253, (Object)HeadIcon.MAGIC, (Object)2255, (Object)HeadIcon.RANGED);
    private static final Map<Integer, HeadIcon> ZEBAK_ATTACKS = ImmutableMap.of((Object)2181, (Object)HeadIcon.MAGIC, (Object)2187, (Object)HeadIcon.RANGED);
    private final Map<Integer, Integer> BABA_BOULDERS = ImmutableMap.of((Object)2250, (Object)6, (Object)2251, (Object)4);
    private static final int EARTHQUAKE_HIT_DELAY_IN_TICKS = 0;
    private static final int P3_LIGHTNING_GRAPHICS_ID = 2197;
    private final DelayedHitTilesTracker earthquakeHitTiles = new DelayedHitTilesTracker();
    private final InstantHitTilesTracker kephriBombHitTiles = new InstantHitTilesTracker();
    private final DelayedHitTilesTracker babaBoulderTiles = new DelayedHitTilesTracker();
    private final InstantHitTilesTracker lightningHitTiles = new InstantHitTilesTracker();
    private final OverheadTracker akkhaOverheadTracker = new OverheadTracker(AKKHA_ATTACKS);
    private final OverheadTracker zebakOverheadTracker = new OverheadTracker(ZEBAK_ATTACKS);
    private final DelayedMistakeTracker delayedMistakeTracker = new DelayedMistakeTracker();

    @Override
    public void cleanup() {
        this.earthquakeHitTiles.clear();
        this.kephriBombHitTiles.clear();
        this.babaBoulderTiles.clear();
        this.lightningHitTiles.clear();
        this.akkhaOverheadTracker.clear();
        this.zebakOverheadTracker.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.WARDENS_P3;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.earthquakeHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P3_EARTHQUAKE);
        }
        if (this.kephriBombHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P3_KEPHRI);
        }
        if (this.babaBoulderTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P3_BABA);
        }
        if (this.lightningHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P3_LIGHTNING);
        }
        mistakes.addAll(this.delayedMistakeTracker.popDelayedMistakes(raider.getName(), this.client.getTickCount()));
        if (this.akkhaOverheadTracker.didMissPrayer(raider)) {
            this.delayedMistakeTracker.addDelayedMistake(raider.getName(), ToaMistake.WARDENS_P3_AKKHA, this.client.getTickCount(), this.getActivationTick(this.akkhaOverheadTracker.getActiveProjectileForRaider(raider)) - this.client.getTickCount());
        }
        if (this.zebakOverheadTracker.didMissPrayer(raider)) {
            this.delayedMistakeTracker.addDelayedMistake(raider.getName(), ToaMistake.WARDENS_P3_ZEBAK, this.client.getTickCount(), this.getActivationTick(this.zebakOverheadTracker.getActiveProjectileForRaider(raider)) - this.client.getTickCount());
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.earthquakeHitTiles.onGameTick(this.client.getTickCount());
        this.kephriBombHitTiles.onGameTick(this.client.getTickCount());
        this.babaBoulderTiles.onGameTick(this.client.getTickCount());
        this.lightningHitTiles.onGameTick(this.client.getTickCount());
        this.akkhaOverheadTracker.onGameTick(this.client.getTickCount());
        this.zebakOverheadTracker.onGameTick(this.client.getTickCount());
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        int id = event.getGraphicsObject().getId();
        if (this.EARTHQUAKE_GRAPHICS_IDS.contains(id)) {
            int activationTick = this.getActivationTick(event.getGraphicsObject(), 0);
            this.earthquakeHitTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
        } else if (this.KEPHRI_BOMB_GRAPHICS_IDS.contains(id)) {
            this.kephriBombHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
        } else if (this.BABA_BOULDERS.containsKey(id)) {
            int activationTick = this.getActivationTick(event.getGraphicsObject(), this.BABA_BOULDERS.get(id));
            this.babaBoulderTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
        } else if (id == 2197) {
            this.lightningHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved event) {
        if (!AKKHA_ATTACKS.containsKey(event.getProjectile().getId()) && !ZEBAK_ATTACKS.containsKey(event.getProjectile().getId())) {
            return;
        }
        int activationTick = this.client.getTickCount();
        this.akkhaOverheadTracker.trackProjectile(event, activationTick);
        activationTick = this.getActivationTick(event.getProjectile());
        this.zebakOverheadTracker.trackProjectile(event, activationTick);
    }

    public DelayedHitTilesTracker getEarthquakeHitTiles() {
        return this.earthquakeHitTiles;
    }

    public InstantHitTilesTracker getKephriBombHitTiles() {
        return this.kephriBombHitTiles;
    }

    public DelayedHitTilesTracker getBabaBoulderTiles() {
        return this.babaBoulderTiles;
    }

    public InstantHitTilesTracker getLightningHitTiles() {
        return this.lightningHitTiles;
    }
}

