/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.boss;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.tracker.DelayedHitTilesTracker;
import com.toamistaketracker.detector.tracker.InstantHitTilesTracker;
import com.toamistaketracker.detector.tracker.OverheadTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Animation;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.HeadIcon;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WardensP1P2Detector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(WardensP1P2Detector.class);
    private static final int RED_PYRAMID_GAME_OBJECT_ID = 45750;
    private static final int YELLOW_PYRAMID_GAME_OBJECT_ID = 45751;
    private static final int PYRAMID_ACTIVE_ANIMATION_ID = 9524;
    private final int PYRAMID_HIT_DELAY_IN_TICKS = 1;
    private static final int DEATH_DOT_PROJECTILE_ID = 2237;
    private static final int DISPERSE_PROJECTILE_ID = 2238;
    private static final String OBELISK_NAME = "Obelisk";
    private static final int DDR_GRAPHICS_ID = 2235;
    private static final int WINDMILL_SHADOW_GRAPHICS_ID = 2236;
    private static final int WINDMILL_HIT_GRAPHICS_ID = 2234;
    private static final int BOMB_GRAPHICS_ID = 2198;
    private static final int DDR_HIT_DELAY_IN_TICKS = 1;
    private static final int LIGHTNING_HIT_DELAY_IN_TICKS = 0;
    private static final int OBELISK_DDR_ANIMATION_ID = 9732;
    private static final int OBELISK_WINDMILL_ANIMATION_ID = 9733;
    private static final int OBELISK_BOMB_ANIMATION_ID = 9727;
    private static final int OBELISK_DEATH_ANIMATION_ID = 9734;
    private static final int OBELISK_DDR_LIGHTNING_GRAPHICS_ID = 2199;
    private static final int OBELISK_WINDMILL_LIGHTNING_GRAPHICS_ID = 2200;
    private static final int PLAYER_BIND_ANIMATION_ID = 9714;
    private static final Map<Integer, HeadIcon> SPECIAL_PRAYER_ATTACKS = ImmutableMap.of((Object)2204, (Object)HeadIcon.MELEE, (Object)2206, (Object)HeadIcon.RANGED, (Object)2208, (Object)HeadIcon.MAGIC);
    private static final Set<Integer> WARDENS_HEALTH_PHASE = ImmutableSet.of((Object)11755, (Object)11758);
    private final List<GameObject> activePyramids = new ArrayList<GameObject>();
    private final DelayedHitTilesTracker pyramidHitTiles = new DelayedHitTilesTracker();
    private ObeliskPhase obeliskPhase;
    private final DelayedHitTilesTracker ddrHitTiles = new DelayedHitTilesTracker();
    private final InstantHitTilesTracker windmillHitTiles = new InstantHitTilesTracker();
    private final DelayedHitTilesTracker bombHitTiles = new DelayedHitTilesTracker();
    private final Set<String> raidersBound = new HashSet<String>();
    private final OverheadTracker specialPrayerOverheadTracker = new OverheadTracker(SPECIAL_PRAYER_ATTACKS);

    @Override
    public void cleanup() {
        this.activePyramids.clear();
        this.pyramidHitTiles.clear();
        this.obeliskPhase = null;
        this.ddrHitTiles.clear();
        this.windmillHitTiles.clear();
        this.bombHitTiles.clear();
        this.raidersBound.clear();
        this.specialPrayerOverheadTracker.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.WARDENS_P1_P2;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.pyramidHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P1_PYRAMID);
        }
        if (this.ddrHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P2_DDR);
        }
        if (this.windmillHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P2_WINDMILL);
        }
        if (this.bombHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.WARDENS_P2_BOMBS);
        }
        if (this.raidersBound.contains(raider.getName())) {
            mistakes.add(ToaMistake.WARDENS_P2_BIND);
        }
        if (this.isSpecialPrayerHit(raider)) {
            mistakes.add(ToaMistake.WARDENS_P2_SPECIAL_PRAYER);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.raidersBound.clear();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() == null || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (event.getActor() instanceof NPC && OBELISK_NAME.equals(name)) {
            ObeliskPhase newObeliskPhase = ObeliskPhase.fromAnimationId(event.getActor().getAnimation());
            if (newObeliskPhase != null) {
                this.obeliskPhase = newObeliskPhase;
            }
        } else if (event.getActor() instanceof Player && this.raidState.getRaiders().containsKey(name) && event.getActor().getAnimation() == 9714) {
            this.raidersBound.add(name);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.computePyramidHitTiles();
        this.pyramidHitTiles.onGameTick(this.client.getTickCount());
        this.ddrHitTiles.onGameTick(this.client.getTickCount());
        this.windmillHitTiles.onGameTick(this.client.getTickCount());
        this.bombHitTiles.onGameTick(this.client.getTickCount());
        this.specialPrayerOverheadTracker.onGameTick(this.client.getTickCount());
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (this.isPyramid(event.getGameObject())) {
            this.activePyramids.add(event.getGameObject());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (this.isPyramid(event.getGameObject())) {
            this.activePyramids.remove(event.getGameObject());
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        switch (event.getGraphicsObject().getId()) {
            case 2235: {
                int activationTick = this.getActivationTick(event.getGraphicsObject(), 1);
                this.ddrHitTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
                break;
            }
            case 2199: {
                int activationTick = this.getActivationTick(event.getGraphicsObject(), 0);
                this.ddrHitTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
                break;
            }
            case 2234: {
                if (this.obeliskPhase == ObeliskPhase.DDR) {
                    this.ddrHitTiles.put(this.client.getTickCount(), this.getWorldPoint(event.getGraphicsObject()));
                    break;
                }
                if (this.obeliskPhase != ObeliskPhase.WINDMILL) break;
                this.windmillHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
                break;
            }
            case 2200: {
                this.windmillHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
                break;
            }
            case 2198: {
                if (this.obeliskPhase != ObeliskPhase.BOMBS) break;
                int activationTick = this.getActivationTick(event.getGraphicsObject(), 0);
                this.bombHitTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
            }
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved event) {
        if (!SPECIAL_PRAYER_ATTACKS.containsKey(event.getProjectile().getId())) {
            return;
        }
        this.specialPrayerOverheadTracker.trackProjectile(event, this.getActivationTick(event.getProjectile()));
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        if (WARDENS_HEALTH_PHASE.contains(event.getNpc().getId())) {
            this.ddrHitTiles.clear();
            this.windmillHitTiles.clear();
            this.bombHitTiles.clear();
            this.specialPrayerOverheadTracker.clear();
        }
    }

    private boolean isSpecialPrayerHit(Raider raider) {
        if (this.vengeanceTracker.didPopVengeance(raider)) {
            return false;
        }
        return this.specialPrayerOverheadTracker.didMissPrayer(raider);
    }

    private void computePyramidHitTiles() {
        this.activePyramids.forEach(pyramid -> {
            Animation animation;
            if (pyramid.getRenderable() instanceof DynamicObject && (animation = ((DynamicObject)pyramid.getRenderable()).getAnimation()) != null && animation.getId() == 9524) {
                int activationTick = this.client.getTickCount() + 1;
                this.pyramidHitTiles.putAll(activationTick, this.compute3By3TilesFromCenter(pyramid.getWorldLocation()));
            }
        });
    }

    private boolean isPyramid(GameObject gameObject) {
        return gameObject.getId() == 45750 || gameObject.getId() == 45751;
    }

    public List<GameObject> getActivePyramids() {
        return this.activePyramids;
    }

    public DelayedHitTilesTracker getPyramidHitTiles() {
        return this.pyramidHitTiles;
    }

    public DelayedHitTilesTracker getDdrHitTiles() {
        return this.ddrHitTiles;
    }

    public InstantHitTilesTracker getWindmillHitTiles() {
        return this.windmillHitTiles;
    }

    public DelayedHitTilesTracker getBombHitTiles() {
        return this.bombHitTiles;
    }

    static enum ObeliskPhase {
        DDR(9732),
        WINDMILL(9733),
        BOMBS(9727),
        DEATH(9734);

        @NonNull
        private final Integer animationId;

        static ObeliskPhase fromAnimationId(int animationId) {
            for (ObeliskPhase obeliskPhase : ObeliskPhase.values()) {
                if (obeliskPhase.getAnimationId() != animationId) continue;
                return obeliskPhase;
            }
            return null;
        }

        private ObeliskPhase(Integer animationId) {
            if (animationId == null) {
                throw new NullPointerException("animationId is marked non-null but is null");
            }
            this.animationId = animationId;
        }

        @NonNull
        public Integer getAnimationId() {
            return this.animationId;
        }
    }
}

