/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.boss;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.tracker.DelayedHitTilesTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KephriDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(KephriDetector.class);
    private static final Map<Integer, Integer> KEPHRI_BOMB_SHADOW_GRAPHICS = ImmutableMap.of((Object)1447, (Object)4, (Object)1446, (Object)3, (Object)2111, (Object)2);
    private static final Set<Integer> KEPHRI_BOMB_GRAPHICS_ID = ImmutableSet.of((Object)2156, (Object)2157, (Object)2158, (Object)2159);
    private static final int SWARM_HEAL_ANIMATION_ID = 9607;
    private static final String SWARM_NAME = "Scarab Swarm";
    private static final int KEPHRI_BOMB_PROJECTILE_ID = 2266;
    private static final int EXPLODING_SCARAB_PROJECTILE_ID = 2147;
    private static final String KEPHRI_NAME = "Kephri";
    private static final Set<Integer> KEPHRI_PHASE_IDS = ImmutableSet.of((Object)11719, (Object)11720, (Object)11721);
    private static final int KEPHRI_DEAD_ID = 11722;
    private int swarmsHealing = 0;
    private Actor kephri;
    private int kephriHealthInternal = -1;
    private static final int KEPHRI_UNVENGEABLE_PHASE = 11720;
    private final DelayedHitTilesTracker bombHitTiles = new DelayedHitTilesTracker();

    @Override
    public void cleanup() {
        this.swarmsHealing = 0;
        this.kephriHealthInternal = -1;
        this.kephri = null;
        this.bombHitTiles.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.KEPHRI;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.isBombHit(raider)) {
            mistakes.add(ToaMistake.KEPHRI_BOMB);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.swarmsHealing = 0;
        this.kephri = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.kephri != null) {
            this.kephriHealthInternal = this.kephri.getHealthRatio();
        }
        this.bombHitTiles.onGameTick(this.client.getTickCount());
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        int id = event.getGraphicsObject().getId();
        if (KEPHRI_BOMB_SHADOW_GRAPHICS.containsKey(id)) {
            int activationTick = this.client.getTickCount() + KEPHRI_BOMB_SHADOW_GRAPHICS.get(id);
            this.bombHitTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() == null || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (event.getActor() instanceof NPC && SWARM_NAME.equals(name) && event.getActor().getAnimation() == 9607 && !event.getActor().isDead()) {
            ++this.swarmsHealing;
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        if (!KEPHRI_NAME.equals(event.getNpc().getName())) {
            return;
        }
        if (this.isPhaseTransition(event.getOld(), event.getNpc().getComposition())) {
            this.kephriHealthInternal = -1;
        } else if (event.getNpc().getId() == 11722) {
            this.shutdown();
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (event.getActor() == null || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (event.getActor() instanceof NPC && KEPHRI_NAME.equals(name)) {
            this.kephri = event.getActor();
        }
    }

    private boolean isBombHit(Raider raider) {
        if (!this.bombHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            return false;
        }
        if (this.kephriHealthInternal == 0) {
            return false;
        }
        return !this.vengeanceTracker.didPopVengeance(raider) || this.isUnvengeablePhase();
    }

    private boolean isUnvengeablePhase() {
        return this.client.getNpcs().stream().anyMatch(npc -> npc.getId() == 11720);
    }

    private boolean isPhaseTransition(NPCComposition oldComp, NPCComposition newComp) {
        return KEPHRI_PHASE_IDS.contains(oldComp.getId()) && KEPHRI_PHASE_IDS.contains(newComp.getId()) && oldComp.getId() != newComp.getId();
    }

    public DelayedHitTilesTracker getBombHitTiles() {
        return this.bombHitTiles;
    }
}

