/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.boss;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.tracker.AppliedHitsplatsTracker;
import com.toamistaketracker.detector.tracker.DelayedHitTilesTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BabaDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(BabaDetector.class);
    private static final Set<WorldPoint> GAP_REGION_TILES = ImmutableSet.of((Object)WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)20, (int)30, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)20, (int)31, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)20, (int)32, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)20, (int)33, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)20, (int)34, (int)0), (Object)WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)21, (int)30, (int)0), (Object[])new WorldPoint[]{WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)21, (int)31, (int)0), WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)21, (int)32, (int)0), WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)21, (int)33, (int)0), WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)21, (int)34, (int)0)});
    private static final WorldPoint BOULDER_WALL_REGION_TILE = WorldPoint.fromRegion((int)RaidRoom.BABA.getRegionId(), (int)22, (int)25, (int)0);
    private static final Map<Integer, Integer> FALLING_BOULDER_GRAPHICS_IDS = ImmutableMap.of((Object)2250, (Object)6, (Object)2251, (Object)4);
    private static final int BABA_SLAM_GRAPHICS_ID = 1103;
    private static final int BOULDER_ROLLED_ANIMATION_ID = 7210;
    private static final int GAP_FALLING_ANIMATION_ID = 4366;
    private static final int BANANA_GAME_OBJECT_ID = 45755;
    private static final int BANANA_SLIP_ANIMATION_ID = 4030;
    private static final int BANANA_GRAPHICS_ID = 1575;
    private static final int BANANA_SLIP_COOLDOWN_IN_TICKS = 3;
    private static final int PLAYER_KNOCK_BACK_ANIMATION_ID = 9799;
    private static final int RUBBLE_EXPLOSION_GRAPHICS_ID = 1463;
    private static final int BABA_PROJECTILE_BOULDER_ANIMATION_ID = 9744;
    private static final int PROJECTILE_BOULDER_DAMAGE_THRESHOLD = 15;
    private static final Integer BOULDER_SPAWN_DELAY_IN_TICKS = 3;
    private static final String BOULDER_NAME = "Boulder";
    private static final String RUBBLE_NAME = "Rubble";
    private static final String BABA_NAME = "Ba-Ba";
    private static final Integer PROJECTILE_BOULDER_DELAY_IN_TICKS = 7;
    private static final int RUBBLE_SAFE_TILES_LENGTH = 5;
    private Set<WorldPoint> gapTiles;
    private WorldPoint boulderWallTile;
    private final Set<WorldPoint> slamHitTiles;
    private final Set<String> raidersFell;
    private final Set<String> raidersSlipping;
    private final Map<String, Integer> raidersRecentlySlipped;
    private final Set<String> raidersRolledAnimation;
    private final Set<String> raidersRolled;
    private final Set<String> raidersRolledLastTick;
    private final List<NPC> boulders;
    private final Map<Integer, List<NPC>> spawnedBoulders;
    private final List<NPC> despawnedBoulders;
    private final Set<WorldPoint> boulderTiles;
    private final Set<WorldPoint> finalBoulderTiles;
    private final List<NPC> rubbles = new ArrayList<NPC>();
    private final Map<NPC, Set<WorldPoint>> safeRubbleTiles = new HashMap<NPC, Set<WorldPoint>>();
    private final Map<NPC, Integer> rubbleHitsplats = new HashMap<NPC, Integer>();
    private final DelayedHitTilesTracker fallingBoulderHitTiles = new DelayedHitTilesTracker();
    private final AppliedHitsplatsTracker fallingBoulderAppliedHitsplats = new AppliedHitsplatsTracker();
    private final DelayedHitTilesTracker projectileBoulderHitTiles = new DelayedHitTilesTracker();
    private final Map<String, List<Integer>> projectileBoulderAppliedHitsplats = new HashMap<String, List<Integer>>();

    public BabaDetector() {
        this.gapTiles = new HashSet<WorldPoint>();
        this.slamHitTiles = new HashSet<WorldPoint>();
        this.raidersFell = new HashSet<String>();
        this.raidersSlipping = new HashSet<String>();
        this.raidersRecentlySlipped = new HashMap<String, Integer>();
        this.raidersRolledAnimation = new HashSet<String>();
        this.raidersRolled = new HashSet<String>();
        this.raidersRolledLastTick = new HashSet<String>();
        this.boulders = new ArrayList<NPC>();
        this.spawnedBoulders = new HashMap<Integer, List<NPC>>();
        this.despawnedBoulders = new ArrayList<NPC>();
        this.boulderTiles = new HashSet<WorldPoint>();
        this.finalBoulderTiles = new HashSet<WorldPoint>();
    }

    @Override
    public void startup() {
        super.startup();
        this.computeGapTiles();
    }

    @Override
    public void cleanup() {
        this.gapTiles.clear();
        this.boulderWallTile = null;
        this.slamHitTiles.clear();
        this.raidersFell.clear();
        this.raidersSlipping.clear();
        this.raidersRecentlySlipped.clear();
        this.raidersRolledAnimation.clear();
        this.raidersRolled.clear();
        this.raidersRolledLastTick.clear();
        this.boulders.clear();
        this.spawnedBoulders.clear();
        this.despawnedBoulders.clear();
        this.boulderTiles.clear();
        this.finalBoulderTiles.clear();
        this.rubbles.clear();
        this.safeRubbleTiles.clear();
        this.rubbleHitsplats.clear();
        this.fallingBoulderHitTiles.clear();
        this.fallingBoulderAppliedHitsplats.clear();
        this.projectileBoulderHitTiles.clear();
        this.projectileBoulderAppliedHitsplats.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.BABA;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.slamHitTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.BABA_SLAM);
        }
        if (this.gapTiles.contains(raider.getPreviousWorldLocation()) && !this.raidersFell.contains(raider.getName())) {
            mistakes.add(ToaMistake.BABA_GAP);
            this.raidersFell.add(raider.getName());
        }
        if (this.isSlip(raider)) {
            mistakes.add(ToaMistake.BABA_BANANA);
            this.raidersRecentlySlipped.put(raider.getName(), this.client.getTickCount());
        }
        if (this.isRollingBoulder(raider)) {
            mistakes.add(ToaMistake.BABA_ROLLING_BOULDER);
            this.raidersRolled.add(raider.getName());
        }
        if (this.isFallingBoulder(raider)) {
            mistakes.add(ToaMistake.BABA_FALLING_BOULDER);
        }
        if (this.isProjectileBoulder(raider)) {
            mistakes.add(ToaMistake.BABA_PROJECTILE_BOULDER);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.slamHitTiles.clear();
        this.raidersSlipping.clear();
        this.raidersRolledAnimation.clear();
        this.raidersRolledLastTick.clear();
        this.raidersRolledLastTick.addAll(this.raidersRolled);
        this.raidersRolled.clear();
        this.rubbleHitsplats.clear();
        this.finalBoulderTiles.clear();
        this.fallingBoulderAppliedHitsplats.clear();
        this.projectileBoulderAppliedHitsplats.clear();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.spawnedBoulders.containsKey(this.client.getTickCount())) {
            List<NPC> spawned = this.spawnedBoulders.remove(this.client.getTickCount());
            List bouldersToSpawn = spawned.stream().filter(b -> !this.despawnedBoulders.remove(b)).collect(Collectors.toList());
            this.boulders.addAll(bouldersToSpawn);
        }
        this.boulderTiles.clear();
        this.boulders.stream().filter(b -> !b.isDead()).forEach(boulder -> this.boulderTiles.addAll(this.computeBoulderTiles(boulder.getWorldLocation())));
        this.boulderTiles.addAll(this.finalBoulderTiles);
        this.fallingBoulderHitTiles.onGameTick(this.client.getTickCount());
        this.projectileBoulderHitTiles.onGameTick(this.client.getTickCount());
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        int id = event.getGraphicsObject().getId();
        if (id == 1103) {
            this.slamHitTiles.add(this.getWorldPoint(event.getGraphicsObject()));
        } else if (FALLING_BOULDER_GRAPHICS_IDS.containsKey(id)) {
            int activationTick = this.client.getTickCount() + FALLING_BOULDER_GRAPHICS_IDS.get(id);
            this.fallingBoulderHitTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getNpc().getName());
        if (BOULDER_NAME.equals(name)) {
            this.spawnedBoulders.computeIfAbsent(this.client.getTickCount() + BOULDER_SPAWN_DELAY_IN_TICKS, k -> new ArrayList()).add(event.getNpc());
        } else if (RUBBLE_NAME.equals(name)) {
            this.rubbles.add(event.getNpc());
            this.safeRubbleTiles.put(event.getNpc(), this.computeSafeRubbleTiles(event.getNpc().getWorldLocation()));
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getNpc().getName());
        if (BOULDER_NAME.equals(name)) {
            this.despawnedBoulders.add(event.getNpc());
            boolean removed = this.boulders.remove(event.getNpc());
            if (removed && !event.getNpc().isDead() && event.getNpc().getWorldLocation().getX() == this.boulderWallTile.getX()) {
                this.finalBoulderTiles.addAll(this.computeBoulderTiles(event.getNpc().getWorldLocation().dx(-1)));
            }
        } else if (RUBBLE_NAME.equals(name)) {
            this.rubbles.remove(event.getNpc());
            this.safeRubbleTiles.remove(event.getNpc());
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() == null || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (event.getActor() instanceof Player && this.raidState.isRaider(event.getActor())) {
            if (event.getActor().getAnimation() == 4030 || event.getActor().getGraphic() == 1575) {
                this.raidersSlipping.add(name);
            } else if (event.getActor().getAnimation() == 7210) {
                this.raidersRolledAnimation.add(name);
            }
        } else if (event.getActor() instanceof NPC && BABA_NAME.equals(name) && event.getActor().getAnimation() == 9744) {
            int activationTick = this.client.getTickCount() + PROJECTILE_BOULDER_DELAY_IN_TICKS;
            this.projectileBoulderHitTiles.put(activationTick, event.getActor().getWorldLocation());
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (event.getActor() == null || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (this.raidState.isRaider(event.getActor())) {
            this.fallingBoulderAppliedHitsplats.addHitsplatForRaider(name);
            if (this.isDamageHitsplat(event.getHitsplat().getHitsplatType()) && event.getHitsplat().getAmount() > 0) {
                this.projectileBoulderAppliedHitsplats.computeIfAbsent(name, k -> new ArrayList()).add(event.getHitsplat().getAmount());
            }
        } else if (event.getActor() instanceof NPC && RUBBLE_NAME.equals(name)) {
            if (event.getActor().getGraphic() == 1463) {
                this.rubbleHitsplats.compute((NPC)event.getActor(), (k, v) -> v == null ? 1 : v + 1);
            } else {
                this.projectileBoulderHitTiles.clear();
            }
        }
    }

    private boolean isDamageHitsplat(int hitsplatType) {
        return hitsplatType == 16 || hitsplatType == 17;
    }

    private boolean isProjectileBoulder(Raider raider) {
        int numSafeRaiders;
        if (this.projectileBoulderHitTiles.getActiveHitTiles().isEmpty()) {
            return false;
        }
        if (this.rubbles.isEmpty()) {
            return false;
        }
        if (!this.projectileBoulderAppliedHitsplats.containsKey(raider.getName())) {
            return false;
        }
        if (this.safeRubbleTiles.values().stream().noneMatch(tiles -> tiles.contains(raider.getPreviousWorldLocation()))) {
            return true;
        }
        List<Integer> hitsplats = this.projectileBoulderAppliedHitsplats.get(raider.getName());
        if (hitsplats.size() == 1) {
            return this.isLargeBoulderHitsplat(hitsplats.get(0));
        }
        if (hitsplats.stream().noneMatch(this::isLargeBoulderHitsplat)) {
            return false;
        }
        if (hitsplats.stream().allMatch(this::isLargeBoulderHitsplat)) {
            return true;
        }
        NPC standingRubble = this.getStandingRubble(raider);
        if (standingRubble == null) {
            return false;
        }
        List<String> raiderNamesOnSameRubble = this.getRaidersStandingOnRubble(standingRubble, raider.getName());
        if (raiderNamesOnSameRubble.isEmpty()) {
            return false;
        }
        boolean allHaveOneHitsplat = raiderNamesOnSameRubble.stream().filter(this.projectileBoulderAppliedHitsplats::containsKey).allMatch(r -> this.projectileBoulderAppliedHitsplats.get(r).size() == 1);
        if (!allHaveOneHitsplat) {
            return false;
        }
        if (!this.rubbleHitsplats.containsKey(standingRubble)) {
            return false;
        }
        int currRubbleHitsplats = this.rubbleHitsplats.get(standingRubble);
        if (currRubbleHitsplats == (numSafeRaiders = (int)raiderNamesOnSameRubble.stream().map(r -> this.projectileBoulderAppliedHitsplats.get(r).get(0)).filter(amount -> !this.isLargeBoulderHitsplat((int)amount)).count())) {
            return true;
        }
        if (currRubbleHitsplats - numSafeRaiders == 1) {
            return false;
        }
        return false;
    }

    private List<String> getRaidersStandingOnRubble(NPC rubble, String currentRaider) {
        return this.raidState.getRaiders().values().stream().filter(r -> !currentRaider.equals(r.getName())).filter(r -> !r.isDead()).filter(r -> rubble.equals(this.getStandingRubble((Raider)r))).map(Raider::getName).collect(Collectors.toList());
    }

    private NPC getStandingRubble(Raider raider) {
        for (Map.Entry<NPC, Set<WorldPoint>> entry : this.safeRubbleTiles.entrySet()) {
            if (!entry.getValue().contains(raider.getPreviousWorldLocation())) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean isLargeBoulderHitsplat(int hitsplatAmount) {
        return hitsplatAmount > 15;
    }

    private Set<WorldPoint> computeSafeRubbleTiles(WorldPoint sw) {
        WorldPoint start = new WorldPoint(sw.getX() - 1, sw.getY() - 1, sw.getPlane());
        HashSet<WorldPoint> safeTiles = new HashSet<WorldPoint>(25);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                safeTiles.add(new WorldPoint(start.getX() + i, start.getY() + j, start.getPlane()));
            }
        }
        return safeTiles;
    }

    private boolean isFallingBoulder(Raider raider) {
        if (raider.getPlayer().getAnimation() == 9799) {
            return false;
        }
        if (!this.fallingBoulderAppliedHitsplats.popHitsplatApplied(raider.getName())) {
            return false;
        }
        if (!this.fallingBoulderHitTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation())) {
            return false;
        }
        return !this.rubbles.isEmpty();
    }

    private boolean isSlip(Raider raider) {
        if (!this.raidersSlipping.contains(raider.getName())) {
            return false;
        }
        boolean wasRecentlySlipped = this.raidersRecentlySlipped.containsKey(raider.getName()) && this.client.getTickCount() - this.raidersRecentlySlipped.get(raider.getName()) <= 3;
        return !wasRecentlySlipped;
    }

    private boolean isRollingBoulder(Raider raider) {
        if (raider.getPreviousWorldLocation() == null || !this.isBoulderPhase() || this.raidersRolledLastTick.contains(raider.getName())) {
            return false;
        }
        boolean wasMovedFar = raider.getPreviousWorldLocation().getX() - raider.getCurrentWorldLocation().getX() > 2;
        return wasMovedFar || this.raidersRolledAnimation.contains(raider.getName()) || this.boulderTiles.contains(raider.getPreviousWorldLocation());
    }

    private boolean isBoulderPhase() {
        return !this.boulders.isEmpty() || !this.spawnedBoulders.isEmpty() || !this.boulderTiles.isEmpty() || !this.finalBoulderTiles.isEmpty();
    }

    private Set<WorldPoint> computeBoulderTiles(WorldPoint sw) {
        WorldPoint cw = sw.dy(1);
        WorldPoint nw = sw.dy(2);
        return ImmutableSet.of((Object)sw.dx(1), (Object)cw.dx(1), (Object)nw.dx(1), (Object)sw.dx(2), (Object)cw.dx(2), (Object)nw.dx(2), (Object[])new WorldPoint[]{sw.dx(3), cw.dx(3), nw.dx(3)});
    }

    private void computeGapTiles() {
        WorldPoint wpPlayer = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint lpPlayer = LocalPoint.fromWorld((Client)this.client, (WorldPoint)wpPlayer);
        if (lpPlayer == null) {
            return;
        }
        int dx = lpPlayer.getSceneX() - wpPlayer.getRegionX();
        int dy = lpPlayer.getSceneY() - wpPlayer.getRegionY();
        this.gapTiles = GAP_REGION_TILES.stream().map(wp -> WorldPoint.fromScene((Client)this.client, (int)(wp.getRegionX() + dx), (int)(wp.getRegionY() + dy), (int)wp.getPlane())).collect(Collectors.toSet());
        this.boulderWallTile = WorldPoint.fromScene((Client)this.client, (int)(BOULDER_WALL_REGION_TILE.getRegionX() + dx), (int)(BOULDER_WALL_REGION_TILE.getRegionY() + dy), (int)BOULDER_WALL_REGION_TILE.getPlane());
    }

    public Set<WorldPoint> getGapTiles() {
        return this.gapTiles;
    }

    public List<NPC> getBoulders() {
        return this.boulders;
    }

    public Set<WorldPoint> getBoulderTiles() {
        return this.boulderTiles;
    }

    public List<NPC> getRubbles() {
        return this.rubbles;
    }

    public Map<NPC, Set<WorldPoint>> getSafeRubbleTiles() {
        return this.safeRubbleTiles;
    }

    public DelayedHitTilesTracker getFallingBoulderHitTiles() {
        return this.fallingBoulderHitTiles;
    }

    public DelayedHitTilesTracker getProjectileBoulderHitTiles() {
        return this.projectileBoulderHitTiles;
    }
}

