/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector.boss;

import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.tracker.AppliedHitsplatsTracker;
import com.toamistaketracker.detector.tracker.DelayedHitTilesTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.GameObject;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AkkhaDetector
extends BaseMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(AkkhaDetector.class);
    private static final Set<Integer> FULL_HOURGLASS_GAME_OBJECT_IDS = ImmutableSet.of((Object)46064, (Object)46065, (Object)46066, (Object)46067);
    private static final Set<Integer> QUADRANT_BOMB_GRAPHICS_IDS = ImmutableSet.of((Object)2256, (Object)2257, (Object)2258, (Object)2259);
    private static final Set<String> ELEMENTAL_ORB_NAMES = ImmutableSet.of((Object)"Orb of Lightning", (Object)"Orb of Darkness", (Object)"Burning Orb", (Object)"Frozen Orb");
    private static final String UNSTABLE_ORB_NAME = "Unstable Orb";
    private static final int UNSTABLE_ORB_POPPED_GRAPHICS_ID = 2260;
    private static final String AKKHA_NAME = "Akkha";
    private static final int HOURGLASS_SPECIAL_SUBTRACTED_CYCLES = 9;
    private static final int HOURGLASS_SPECIAL_HIT_DELAY_IN_TICKS = 1;
    private static final int QUADRANT_EXPLODE_HIT_DELAY_IN_TICKS = 0;
    private boolean isAkkhaPresent;
    private final Set<String> raidersPreviouslyMadeQuadrantMistake = new HashSet<String>();
    private final List<GameObject> activeFullHourglasses = new ArrayList<GameObject>();
    private final DelayedHitTilesTracker quadrantBombTiles = new DelayedHitTilesTracker();
    private final Set<WorldPoint> elementalOrbHitTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> unstableOrbHitTiles = new HashSet<WorldPoint>();
    private final AppliedHitsplatsTracker appliedHitsplats = new AppliedHitsplatsTracker();

    @Override
    public void cleanup() {
        this.isAkkhaPresent = false;
        this.activeFullHourglasses.clear();
        this.raidersPreviouslyMadeQuadrantMistake.clear();
        this.quadrantBombTiles.clear();
        this.elementalOrbHitTiles.clear();
        this.unstableOrbHitTiles.clear();
        this.appliedHitsplats.clear();
    }

    @Override
    public RaidRoom getRaidRoom() {
        return RaidRoom.AKKHA;
    }

    @Override
    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        if (this.isQuadrantHit(raider)) {
            mistakes.add(ToaMistake.AKKHA_SPECIAL_QUADRANT_BOMB);
            this.raidersPreviouslyMadeQuadrantMistake.add(raider.getName());
        } else {
            this.raidersPreviouslyMadeQuadrantMistake.remove(raider.getName());
        }
        if (this.elementalOrbHitTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(ToaMistake.AKKHA_SPECIAL_ELEMENTAL_ORBS);
        }
        if (this.unstableOrbHitTiles.contains(raider.getPreviousWorldLocation()) && this.appliedHitsplats.popHitsplatApplied(raider.getName())) {
            mistakes.add(ToaMistake.AKKHA_UNSTABLE_ORB);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.elementalOrbHitTiles.clear();
        this.unstableOrbHitTiles.clear();
        this.appliedHitsplats.clear();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.quadrantBombTiles.onGameTick(this.client.getTickCount());
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        if (!QUADRANT_BOMB_GRAPHICS_IDS.contains(event.getGraphicsObject().getId())) {
            return;
        }
        int activationTick = this.isHourglassSpecial() ? this.getActivationTickWithSubtractedCycles(event.getGraphicsObject(), 1, 9) : this.getActivationTick(event.getGraphicsObject(), 0);
        this.quadrantBombTiles.put(activationTick, this.getWorldPoint(event.getGraphicsObject()));
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        if (!(event.getActor() instanceof NPC) || event.getActor().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getActor().getName());
        if (event.getActor() instanceof NPC && UNSTABLE_ORB_NAME.equals(name) && event.getActor().getGraphic() == 2260) {
            this.unstableOrbHitTiles.add(this.getWorldPointTransformedTowardsLocal(event.getActor()));
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (this.isFullHourglass(event.getGameObject())) {
            this.activeFullHourglasses.add(event.getGameObject());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (this.isFullHourglass(event.getGameObject())) {
            this.activeFullHourglasses.remove(event.getGameObject());
        }
    }

    private boolean isFullHourglass(GameObject gameObject) {
        return FULL_HOURGLASS_GAME_OBJECT_IDS.contains(gameObject.getId());
    }

    private WorldPoint getWorldPointTransformedTowardsLocal(Actor actor) {
        WorldPoint worldPoint = actor.getWorldLocation();
        WorldPoint worldPointFromLocal = this.getWorldPoint(actor);
        int distX = worldPoint.getX() - worldPointFromLocal.getX();
        int distY = worldPoint.getY() - worldPointFromLocal.getY();
        int dx = Integer.compare(0, distX);
        int dy = Integer.compare(0, distY);
        WorldPoint transformed = worldPoint.dx(dx).dy(dy);
        return transformed;
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getNpc().getName());
        if (AKKHA_NAME.equals(name)) {
            this.isAkkhaPresent = true;
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        String name = Text.removeTags((String)event.getNpc().getName());
        if (ELEMENTAL_ORB_NAMES.contains(name)) {
            this.elementalOrbHitTiles.add(this.getWorldPoint(event.getActor()));
        } else if (AKKHA_NAME.equals(name)) {
            this.isAkkhaPresent = false;
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (this.raidState.isRaider(event.getActor())) {
            this.appliedHitsplats.addHitsplatForRaider(event.getActor().getName());
        }
    }

    public boolean isHourglassSpecial() {
        return !this.activeFullHourglasses.isEmpty() && this.isAkkhaPresent;
    }

    private boolean isQuadrantHit(Raider raider) {
        return this.quadrantBombTiles.getActiveHitTiles().contains(raider.getPreviousWorldLocation()) && !this.raidersPreviouslyMadeQuadrantMistake.contains(raider.getName());
    }

    private int getActivationTickWithSubtractedCycles(GraphicsObject graphicsObject, int hitDelay, int subtractedCycles) {
        int ticksToStart = (graphicsObject.getStartCycle() - this.client.getGameCycle() - subtractedCycles) / 30;
        return this.client.getTickCount() + ticksToStart + hitDelay;
    }
}

