/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector;

import com.google.common.annotations.VisibleForTesting;
import com.toamistaketracker.RaidState;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.BaseMistakeDetector;
import com.toamistaketracker.detector.boss.AkkhaDetector;
import com.toamistaketracker.detector.boss.BabaDetector;
import com.toamistaketracker.detector.boss.KephriDetector;
import com.toamistaketracker.detector.boss.WardensP1P2Detector;
import com.toamistaketracker.detector.boss.WardensP3Detector;
import com.toamistaketracker.detector.boss.ZebakDetector;
import com.toamistaketracker.detector.death.DeathDetector;
import com.toamistaketracker.detector.puzzle.ApmekenPuzzleDetector;
import com.toamistaketracker.detector.puzzle.CrondisPuzzleDetector;
import com.toamistaketracker.detector.puzzle.HetPuzzleDetector;
import com.toamistaketracker.detector.puzzle.ScabarasPuzzleDetector;
import com.toamistaketracker.detector.tracker.BaseRaidTracker;
import com.toamistaketracker.detector.tracker.VengeanceTracker;
import com.toamistaketracker.events.RaidRoomChanged;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MistakeDetectorManager {
    private static final Logger log = LoggerFactory.getLogger(MistakeDetectorManager.class);
    private static final String WIPE_GAME_MESSAGE = "Your party failed to complete the challenge";
    private final Client client;
    private final EventBus eventBus;
    private final RaidState raidstate;
    private final VengeanceTracker vengeanceTracker;
    private final List<BaseRaidTracker> raidTrackers;
    private final List<BaseMistakeDetector> mistakeDetectors;
    @VisibleForTesting
    private boolean started;

    @Inject
    public MistakeDetectorManager(Client client, EventBus eventBus, RaidState raidState, VengeanceTracker vengeanceTracker, HetPuzzleDetector hetPuzzleDetector, CrondisPuzzleDetector crondisPuzzleDetector, ScabarasPuzzleDetector scabarasPuzzleDetector, ApmekenPuzzleDetector apmekenPuzzleDetector, AkkhaDetector akkhaDetector, ZebakDetector zebakDetector, KephriDetector kephriDetector, BabaDetector babaDetector, WardensP1P2Detector wardensP1P2Detector, WardensP3Detector wardensP3Detector, DeathDetector deathDetector) {
        this.raidTrackers = Arrays.asList(vengeanceTracker);
        this.mistakeDetectors = new ArrayList<BaseMistakeDetector>(Arrays.asList(hetPuzzleDetector, crondisPuzzleDetector, scabarasPuzzleDetector, apmekenPuzzleDetector, akkhaDetector, zebakDetector, kephriDetector, babaDetector, wardensP1P2Detector, wardensP3Detector, deathDetector));
        this.client = client;
        this.eventBus = eventBus;
        this.raidstate = raidState;
        this.vengeanceTracker = vengeanceTracker;
        this.started = false;
    }

    public void startup() {
        this.started = true;
        this.eventBus.register((Object)this);
        this.raidTrackers.forEach(BaseRaidTracker::startup);
        this.mistakeDetectors.stream().filter(d -> d.getRaidRoom() == null).forEach(BaseMistakeDetector::startup);
    }

    public void shutdown() {
        this.mistakeDetectors.forEach(BaseMistakeDetector::shutdown);
        this.raidTrackers.forEach(BaseRaidTracker::shutdown);
        this.eventBus.unregister((Object)this);
        this.started = false;
    }

    public List<ToaMistake> detectMistakes(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        if (!this.started) {
            return Collections.emptyList();
        }
        ArrayList<ToaMistake> mistakes = new ArrayList<ToaMistake>();
        for (BaseMistakeDetector mistakeDetector : this.mistakeDetectors) {
            if (!mistakeDetector.isDetectingMistakes() || raider.isDead()) continue;
            mistakes.addAll(mistakeDetector.detectMistakes(raider));
        }
        return mistakes;
    }

    public void afterDetect() {
        if (!this.started) {
            return;
        }
        this.raidTrackers.forEach(BaseRaidTracker::afterDetect);
        for (BaseMistakeDetector mistakeDetector : this.mistakeDetectors) {
            if (!mistakeDetector.isDetectingMistakes()) continue;
            mistakeDetector.afterDetect();
        }
    }

    @Subscribe
    public void onRaidRoomChanged(RaidRoomChanged event) {
        this.mistakeDetectors.stream().filter(d -> d.getRaidRoom() != null).forEach(detector -> {
            if (detector.getRaidRoom() == event.getNewRaidRoom()) {
                detector.startup();
            } else if (detector.getRaidRoom() == event.getPrevRaidRoom()) {
                detector.shutdown();
            }
        });
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        if (message != null && message.startsWith(WIPE_GAME_MESSAGE)) {
            log.debug("Team wiped -- Resetting all active detectors");
            this.mistakeDetectors.stream().filter(BaseMistakeDetector::isDetectingMistakes).forEach(d -> {
                d.shutdown();
                d.startup();
            });
        }
    }

    public List<BaseRaidTracker> getRaidTrackers() {
        return this.raidTrackers;
    }

    public List<BaseMistakeDetector> getMistakeDetectors() {
        return this.mistakeDetectors;
    }

    public boolean isStarted() {
        return this.started;
    }
}

