/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker.detector;

import com.google.common.collect.ImmutableSet;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.RaidState;
import com.toamistaketracker.Raider;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.detector.tracker.VengeanceTracker;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GraphicsObject;
import net.runelite.api.Projectile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.eventbus.EventBus;

public abstract class BaseMistakeDetector {
    protected static final int CYCLES_PER_GAME_TICK = 30;
    @Inject
    protected Client client;
    @Inject
    protected EventBus eventBus;
    @Inject
    protected RaidState raidState;
    @Inject
    protected VengeanceTracker vengeanceTracker;

    public void startup() {
        this.cleanup();
        this.eventBus.register((Object)this);
    }

    public void shutdown() {
        this.eventBus.unregister((Object)this);
        this.cleanup();
    }

    public abstract void cleanup();

    public abstract RaidRoom getRaidRoom();

    public abstract List<ToaMistake> detectMistakes(@NonNull Raider var1);

    public abstract void afterDetect();

    public boolean isDetectingMistakes() {
        if (this.getRaidRoom() == null) {
            return this.raidState.isInRaid();
        }
        return this.raidState.getCurrentRoom() == this.getRaidRoom();
    }

    protected WorldPoint getWorldPoint(Actor actor) {
        return WorldPoint.fromLocal((Client)this.client, (LocalPoint)actor.getLocalLocation());
    }

    protected WorldPoint getWorldPoint(GraphicsObject graphicsObject) {
        return WorldPoint.fromLocal((Client)this.client, (LocalPoint)graphicsObject.getLocation());
    }

    protected Set<WorldPoint> compute3By3TilesFromCenter(WorldPoint center) {
        WorldPoint west = center.dx(-1);
        WorldPoint east = center.dx(1);
        return ImmutableSet.of((Object)west, (Object)center, (Object)east, (Object)west.dy(-1), (Object)center.dy(-1), (Object)east.dy(-1), (Object[])new WorldPoint[]{west.dy(1), center.dy(1), east.dy(1)});
    }

    protected int getActivationTick(GraphicsObject graphicsObject, int hitDelay) {
        int ticksToStart = (graphicsObject.getStartCycle() - this.client.getGameCycle()) / 30;
        return this.client.getTickCount() + ticksToStart + hitDelay;
    }

    protected int getActivationTick(Projectile projectile) {
        int ticksRemaining = projectile.getRemainingCycles() / 30;
        return this.client.getTickCount() + ticksRemaining;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setRaidState(RaidState raidState) {
        this.raidState = raidState;
    }

    public void setVengeanceTracker(VengeanceTracker vengeanceTracker) {
        this.vengeanceTracker = vengeanceTracker;
    }
}

