/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker;

import com.google.inject.Provides;
import com.toamistaketracker.RaidState;
import com.toamistaketracker.Raider;
import com.toamistaketracker.StackingBehavior;
import com.toamistaketracker.ToaMistake;
import com.toamistaketracker.ToaMistakeTrackerConfig;
import com.toamistaketracker.detector.MistakeDetectorManager;
import com.toamistaketracker.detector.tracker.VengeanceTracker;
import com.toamistaketracker.events.InRaidChanged;
import com.toamistaketracker.events.RaidEntered;
import com.toamistaketracker.panel.ToaMistakeTrackerPanel;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Toa Mistake Tracker")
public class ToaMistakeTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ToaMistakeTrackerPlugin.class);
    public static final int CYCLES_PER_GAME_TICK = 30;
    static final String CONFIG_GROUP = "toaMistakeTracker";
    private static final int OVERHEAD_TEXT_TICK_TIMEOUT = 5;
    private static final int CYCLES_FOR_OVERHEAD_TEXT = 150;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ToaMistakeTrackerConfig config;
    @Inject
    private EventBus eventBus;
    @Inject
    private MistakeDetectorManager mistakeDetectorManager;
    @Inject
    private RaidState raidState;
    @Inject
    private VengeanceTracker vengeanceTracker;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientToolbar clientToolbar;
    private final BufferedImage icon = ImageUtil.loadImageResource(ToaMistakeTrackerPlugin.class, (String)"panel-icon.png");
    private ToaMistakeTrackerPanel panel;
    private NavigationButton navButton;

    protected void startUp() throws Exception {
        this.panel = (ToaMistakeTrackerPanel)((Object)this.injector.getInstance(ToaMistakeTrackerPanel.class));
        this.panel.loadHeaderIcon(this.icon);
        this.navButton = NavigationButton.builder().tooltip("Toa Mistake Tracker").icon(this.icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.clientThread.invoke(() -> this.raidState.startUp());
        this.panel.reload();
    }

    protected void shutDown() throws Exception {
        this.raidState.shutDown();
        this.mistakeDetectorManager.shutdown();
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel = null;
    }

    @Subscribe(priority=-1.0f)
    public void onGameTick(GameTick event) {
        if (!this.raidState.isInRaid()) {
            return;
        }
        this.detectAll();
        this.afterDetectAll();
    }

    private void detectAll() {
        for (Raider raider : this.raidState.getRaiders().values()) {
            if (raider == null) continue;
            this.detect(raider);
        }
    }

    private void detect(@NonNull Raider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked non-null but is null");
        }
        List<ToaMistake> mistakes = this.mistakeDetectorManager.detectMistakes(raider);
        if (!mistakes.isEmpty()) {
            log.debug(this.client.getTickCount() + " Found mistakes for " + raider.getName() + " - " + mistakes);
            for (ToaMistake mistake : mistakes) {
                if (mistake == ToaMistake.DEATH) {
                    raider.setDead(true);
                }
                this.addChatMessageForMistake(raider, mistake);
                this.addMistakeToOverlayPanel(raider, mistake);
            }
        }
        this.afterDetect(raider);
    }

    private void afterDetect(Raider raider) {
        raider.setPreviousWorldLocationForOverlay(raider.getPreviousWorldLocation());
        raider.setPreviousWorldLocation(raider.getCurrentWorldLocation());
    }

    private void afterDetectAll() {
        this.mistakeDetectorManager.afterDetect();
    }

    private void addChatMessageForMistake(Raider raider, ToaMistake mistake) {
        int mistakeCount = this.config.mistakeMessageStacking() == StackingBehavior.SAME_MISTAKES_ONLY ? this.panel.getCurrentMistakeCountForPlayer(raider.getName(), mistake) : this.panel.getCurrentTotalMistakeCountForPlayer(raider.getName());
        String msg = ToaMistake.getChatMessageForMistakeCount(this.config, mistake, mistakeCount);
        if (msg.length() > 40) {
            msg = msg.substring(0, 40);
        }
        if (msg.isEmpty()) {
            return;
        }
        Player player = raider.getPlayer();
        if (this.config.showMistakesOnOverheadText()) {
            Object overheadText = msg;
            if (this.vengeanceTracker.didPopVengeance(raider)) {
                overheadText = "Taste vengeance! " + (String)overheadText;
            }
            player.setOverheadText((String)overheadText);
            player.setOverheadCycle(150);
        }
        if (this.config.showMistakesInChat()) {
            this.client.addChatMessage(ChatMessageType.PUBLICCHAT, player.getName(), msg, null);
        }
    }

    private void addMistakeToOverlayPanel(Raider raider, ToaMistake mistake) {
        ToaMistake groupedMistake = ToaMistake.toGroupedMistake(mistake);
        SwingUtilities.invokeLater(() -> this.panel.addMistakeForPlayer(raider.getName(), groupedMistake));
    }

    @Subscribe
    public void onInRaidChanged(InRaidChanged e) {
        if (e.isInRaid()) {
            log.debug("Starting detectors");
            this.mistakeDetectorManager.startup();
        } else {
            log.debug("Shutting down detectors");
            this.mistakeDetectorManager.shutdown();
        }
    }

    @Subscribe
    public void onRaidEntered(RaidEntered event) {
        this.panel.newRaid(event.getRaiderNames());
    }

    @Provides
    ToaMistakeTrackerConfig provideConfig(ConfigManager configManager) {
        return (ToaMistakeTrackerConfig)configManager.getConfig(ToaMistakeTrackerConfig.class);
    }
}

