/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import lombok.NonNull;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;

public class Raider {
    private static final Set<Integer> GHOST_POSE_IDS = ImmutableSet.of((Object)5538, (Object)5539);
    @NonNull
    private final Player player;
    private WorldPoint previousWorldLocation;
    private WorldPoint previousWorldLocationForOverlay;
    private boolean isDead;

    Raider(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
    }

    public String getName() {
        return this.player.getName();
    }

    public WorldPoint getCurrentWorldLocation() {
        return this.player.getWorldLocation();
    }

    public boolean isDead() {
        return this.isDead || GHOST_POSE_IDS.contains(this.player.getPoseAnimation());
    }

    @NonNull
    public Player getPlayer() {
        return this.player;
    }

    public WorldPoint getPreviousWorldLocation() {
        return this.previousWorldLocation;
    }

    void setPreviousWorldLocation(WorldPoint previousWorldLocation) {
        this.previousWorldLocation = previousWorldLocation;
    }

    public WorldPoint getPreviousWorldLocationForOverlay() {
        return this.previousWorldLocationForOverlay;
    }

    void setPreviousWorldLocationForOverlay(WorldPoint previousWorldLocationForOverlay) {
        this.previousWorldLocationForOverlay = previousWorldLocationForOverlay;
    }

    void setDead(boolean isDead) {
        this.isDead = isDead;
    }
}

