/*
 * Decompiled with CFR 0.152.
 */
package com.toamistaketracker;

import com.google.common.collect.ImmutableList;
import com.toamistaketracker.RaidRoom;
import com.toamistaketracker.Raider;
import com.toamistaketracker.events.InRaidChanged;
import com.toamistaketracker.events.RaidEntered;
import com.toamistaketracker.events.RaidRoomChanged;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RaidState {
    private static final Logger log = LoggerFactory.getLogger(RaidState.class);
    private static final int TOA_HUD_INIT_STATUS_NAMES_SCRIPT_ID = 6585;
    private static final int TOA_RAIDERS_VARC_START = 1099;
    private static final int MAX_RAIDERS = 8;
    private final Client client;
    private final EventBus eventBus;
    private boolean inRaid;
    private RaidRoom currentRoom;
    private final Map<String, Raider> raiders = new HashMap<String, Raider>();
    private int prevRegion;
    private boolean newRaid;

    public void startUp() {
        this.clearState();
        this.eventBus.register((Object)this);
    }

    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.clearState();
    }

    private void clearState() {
        this.inRaid = false;
        this.currentRoom = null;
        this.raiders.clear();
        this.prevRegion = -1;
        this.newRaid = false;
    }

    @Subscribe(priority=5.0f)
    public void onGameTick(GameTick e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int newRegion = this.getRegion();
        if (newRegion == -1) {
            return;
        }
        if (this.prevRegion != newRegion) {
            this.regionChanged(newRegion);
        }
        this.prevRegion = newRegion;
        if (!this.inRaid) {
            this.raiders.clear();
            return;
        }
        if (this.raiders.isEmpty()) {
            this.tryLoadRaiders();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            for (Raider raider : this.raiders.values()) {
                raider.setDead(false);
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 6585) {
            this.tryLoadRaiders();
        }
    }

    public boolean isRaider(Actor actor) {
        return this.raiders.containsKey(actor.getName());
    }

    private int getRegion() {
        LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
        if (localPoint == null) {
            return -1;
        }
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint).getRegionID();
    }

    private void regionChanged(int newRegion) {
        boolean newInRaid;
        this.currentRoom = RaidRoom.forRegionId(newRegion);
        if (this.currentRoom == null) {
            return;
        }
        log.debug("New room: {}", (Object)this.currentRoom);
        boolean bl = newInRaid = this.currentRoom != RaidRoom.RAID_LOBBY_OUTSIDE;
        if (newInRaid != this.inRaid) {
            log.debug("In Raid changed: {}", (Object)newInRaid);
            this.eventBus.post((Object)new InRaidChanged(newInRaid));
        }
        this.inRaid = newInRaid;
        RaidRoom prevRoom = RaidRoom.forRegionId(this.prevRegion);
        if (prevRoom == RaidRoom.RAID_LOBBY_OUTSIDE && this.currentRoom == RaidRoom.RAID_LOBBY_INSIDE) {
            this.newRaid = true;
        } else {
            log.debug("Raid room changed: {}", (Object)this.currentRoom);
            this.eventBus.post((Object)RaidRoomChanged.builder().newRaidRoom(this.currentRoom).prevRaidRoom(prevRoom).build());
        }
    }

    private void tryLoadRaiders() {
        log.debug("Setting raiders");
        this.raiders.clear();
        HashSet<String> raiderNames = new HashSet<String>(8);
        for (int i = 0; i < 8; ++i) {
            String name = this.client.getVarcStrValue(1099 + i);
            if (name == null || name.isEmpty()) continue;
            raiderNames.add(Text.sanitize((String)name));
        }
        for (Player player : this.client.getPlayers()) {
            if (player == null || player.getName() == null || this.raiders.containsKey(player.getName()) || !raiderNames.contains(player.getName())) continue;
            this.raiders.put(player.getName(), new Raider(player));
        }
        log.debug("Loaded raiderNames: {}", raiderNames);
        log.debug("Loaded raiders: {}", this.raiders.keySet());
        if (this.raiders.isEmpty() || this.raiders.size() < raiderNames.size()) {
            log.debug("Not enough raiders loaded. Will try again later...");
            this.raiders.clear();
            return;
        }
        if (this.newRaid) {
            log.debug("New raid");
            this.eventBus.post((Object)new RaidEntered((List<String>)ImmutableList.copyOf(this.raiders.keySet())));
            this.newRaid = false;
        }
    }

    @Inject
    public RaidState(Client client, EventBus eventBus) {
        this.client = client;
        this.eventBus = eventBus;
    }

    public boolean isInRaid() {
        return this.inRaid;
    }

    public RaidRoom getCurrentRoom() {
        return this.currentRoom;
    }

    public Map<String, Raider> getRaiders() {
        return this.raiders;
    }
}

