/*
 * Decompiled with CFR 0.152.
 */
package runelite.untrimmed;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import runelite.untrimmed.UntrimmedConfig;

public class WarningOverlay
extends OverlayPanel {
    private final UntrimmedConfig config;
    private final Client client;
    private String message;
    private boolean isSafe;

    @Inject
    private WarningOverlay(UntrimmedConfig config, Client client) {
        this.config = config;
        this.client = client;
        this.message = "Placeholder";
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setIsSafe(boolean isSafe) {
        this.isSafe = isSafe;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left(this.message).build());
        if (this.isSafe) {
            this.panelComponent.setBackgroundColor(this.config.safeColor());
        } else if (this.config.shouldFlash()) {
            if (this.client.getGameCycle() % 40 >= 20) {
                this.panelComponent.setBackgroundColor(this.config.flashColor1());
            } else {
                this.panelComponent.setBackgroundColor(this.config.flashColor2());
            }
        } else {
            this.panelComponent.setBackgroundColor(this.config.flashColor1());
        }
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        return this.panelComponent.render(graphics);
    }
}

