/*
 * Decompiled with CFR 0.152.
 */
package runelite.untrimmed;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Skill;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import runelite.untrimmed.CapeManager;
import runelite.untrimmed.CapeStorageLocation;
import runelite.untrimmed.SkillXpManager;
import runelite.untrimmed.UntrimmedConfig;
import runelite.untrimmed.WarningOverlay;

@PluginDescriptor(name="Untrimmed Warning")
public class UntrimmedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UntrimmedPlugin.class);
    @Inject
    private Client client;
    @Inject
    private UntrimmedConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WarningOverlay overlay;
    private CapeManager capeManager;
    private SkillXpManager skillXpManager;
    private boolean finishedInitializingCharacter = false;

    protected void startUp() throws Exception {
        this.finishedInitializingCharacter = false;
        this.capeManager = new CapeManager(this.client, this.configManager);
        this.skillXpManager = new SkillXpManager(this.client);
    }

    protected void shutDown() {
        this.capeManager.shutDown();
    }

    @Subscribe
    void onActorDeath(ActorDeath actorDeath) {
        if (this.client.getLocalPlayer() == null || actorDeath.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        this.capeManager.onActorDeath(actorDeath);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.finishedInitializingCharacter) {
            this.skillXpManager.fetchSkillXp();
            this.updateCapeInfoBox();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.finishedInitializingCharacter) {
            this.finishedInitializingCharacter = true;
            this.skillXpManager.fetchSkillXp();
            this.updateCapeInfoBox();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        this.capeManager.onItemContainerChanged(itemContainerChanged);
        this.updateCapeInfoBox();
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        this.capeManager.onItemSpawned(itemSpawned);
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        this.capeManager.onItemDespawned(itemDespawned);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuAction type = MenuAction.of((int)event.getType());
        if (type == MenuAction.GROUND_ITEM_FIRST_OPTION || type == MenuAction.GROUND_ITEM_SECOND_OPTION || type == MenuAction.GROUND_ITEM_THIRD_OPTION || type == MenuAction.GROUND_ITEM_FOURTH_OPTION || type == MenuAction.GROUND_ITEM_FIFTH_OPTION || type == MenuAction.WIDGET_TARGET_ON_GROUND_ITEM) {
            int itemId = event.getIdentifier();
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            MenuEntry lastEntry = menuEntries[menuEntries.length - 1];
            if (this.config.hidePickup() && this.capeManager.isUntrimmedCape(itemId)) {
                lastEntry.setDeprioritized(true);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("untrimmed-warning")) {
            return;
        }
        if (this.finishedInitializingCharacter) {
            this.updateCapeInfoBox();
        }
    }

    private void updateCapeInfoBox() {
        if (!this.skillXpManager.hasAny99() || this.skillXpManager.isMaxed()) {
            this.hideOverlay();
            return;
        }
        if (this.skillXpManager.isCloseToNew99(this.config.warningXpRange())) {
            this.showOverlay(this.skillXpManager.closestNew99(), this.capeManager.capeLocation());
        } else {
            this.hideOverlay();
        }
    }

    private void showOverlay(Skill closestNew99, CapeStorageLocation capeStorageLocation) {
        this.overlayManager.remove((Overlay)this.overlay);
        String message = "Near 99 " + closestNew99.getName() + ". " + capeStorageLocation.capeStatus();
        this.overlay.setMessage(message);
        this.overlay.setIsSafe(capeStorageLocation.isSafe());
        this.overlayManager.add((Overlay)this.overlay);
    }

    private void hideOverlay() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    UntrimmedConfig provideConfig(ConfigManager configManager) {
        return (UntrimmedConfig)configManager.getConfig(UntrimmedConfig.class);
    }
}

