/*
 * Decompiled with CFR 0.152.
 */
package runelite.untrimmed;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.runelite.api.Client;
import net.runelite.api.Skill;

public class SkillXpManager {
    private Map<Skill, Integer> skillXp;
    private static final int LVL_99_XP = 13034431;
    private final Client client;

    public SkillXpManager(Client client) {
        this.client = client;
        this.initializeSkillXp();
    }

    private void initializeSkillXp() {
        this.skillXp = new HashMap<Skill, Integer>();
        for (Skill skill : Skill.values()) {
            if (skill.equals((Object)Skill.OVERALL)) continue;
            this.skillXp.put(skill, this.client.getSkillExperience(skill));
        }
    }

    public boolean hasAny99() {
        for (int xp : this.skillXp.values()) {
            if (xp < 13034431) continue;
            return true;
        }
        return false;
    }

    public boolean isMaxed() {
        for (int xp : this.skillXp.values()) {
            if (xp >= 13034431) continue;
            return false;
        }
        return true;
    }

    public boolean isCloseToNew99(int remainingXp) {
        for (int xp : this.skillXp.values()) {
            if (xp < 13034431 - remainingXp || xp >= 13034431) continue;
            return true;
        }
        return false;
    }

    public Skill closestNew99() {
        Optional closestSkill = this.skillXp.entrySet().stream().filter(entry -> (Integer)entry.getValue() < 13034431).sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).findFirst();
        return closestSkill.map(Map.Entry::getKey).get();
    }

    public void fetchSkillXp() {
        this.initializeSkillXp();
    }

    public String toString() {
        return "SkillXpManager(skillXp=" + this.skillXp + ", client=" + this.client + ")";
    }
}

