/*
 * Decompiled with CFR 0.152.
 */
package runelite.untrimmed;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import runelite.untrimmed.CapeStorageLocation;

public class CapeTracker
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CapeTracker.class);
    private Map<CapeStorageLocation, Integer> capesFound = new HashMap<CapeStorageLocation, Integer>();
    private ConfigManager configManager;

    public CapeTracker(ConfigManager configManager) {
        this.configManager = configManager;
        this.startUp();
    }

    public void persistData() {
        log.debug("shutting down");
        log.debug("CapesFound=" + this.capesFound);
        for (CapeStorageLocation location : CapeStorageLocation.values()) {
            String key = "capetracker." + location.name();
            this.configManager.setConfiguration("untrimmed-warning", key, (Object)this.capesFound.getOrDefault((Object)location, 0));
        }
    }

    private void startUp() {
        log.debug("starting up");
        for (CapeStorageLocation location : CapeStorageLocation.values()) {
            String key = "capetracker." + location.name();
            Integer count = (Integer)this.configManager.getConfiguration("untrimmed-warning", key, Integer.class);
            if (count == null) {
                this.capesFound.put(location, 0);
                continue;
            }
            this.capesFound.put(location, count);
        }
        log.debug("CapesFound=" + this.capesFound);
    }

    public int put(CapeStorageLocation capeStorageLocation, int quantity) {
        Integer oldValue = this.capesFound.put(capeStorageLocation, quantity);
        this.persistData();
        if (oldValue == null) {
            return 0;
        }
        return oldValue;
    }

    public Set<Map.Entry<CapeStorageLocation, Integer>> entrySet() {
        return this.capesFound.entrySet();
    }
}

