/*
 * Decompiled with CFR 0.152.
 */
package runelite.untrimmed;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.InventoryID;
import runelite.untrimmed.Region;

public enum CapeStorageLocation {
    GRAVESTONE("at gravestone", 525, Collections.emptyList(), true),
    DEATH_OFFICE("at Death's Office", 525, Collections.emptyList(), true),
    ZULRAH("in death storage at Zulrah", 525, Arrays.asList(33, 0), true),
    HESPORI("in death storage at Hespori", 525, Arrays.asList(15, 16), true),
    COX("in private storage at Chambers of Xeric", 583, Collections.emptyList(), true),
    GROUND("on the ground (TELE-GRAB ONLY!)", -1, Collections.emptyList(), true),
    UNKNOWN("at an unknown location", -1, Collections.emptyList(), false),
    BANK("in the Bank", InventoryID.BANK.getId(), Collections.emptyList(), false),
    INVENTORY("in the inventory", InventoryID.INVENTORY.getId(), Collections.emptyList(), false),
    EQUIPMENT("equipped", InventoryID.EQUIPMENT.getId(), Collections.emptyList(), false),
    HYDRA("in death storage at Hydra", 525, Arrays.asList(13, 14), false),
    VORKATH("in death storage at Vorkath", 525, Arrays.asList(5, 6), false),
    TOB("in death storage at Theatre of Blood", 525, Arrays.asList(11, 12), false);

    private final String description;
    private final int inventoryID;
    private final List<Integer> deathVarbits;
    private final boolean isSafe;

    private CapeStorageLocation(String description, int inventoryID, List<Integer> deathVarbits, boolean isSafe) {
        this.description = description;
        this.inventoryID = inventoryID;
        this.deathVarbits = deathVarbits;
        this.isSafe = isSafe;
    }

    public boolean isSafe() {
        return this.isSafe;
    }

    public String capeStatus() {
        if (this.isSafe) {
            return "Your untrimmed cape is SAFE because it is " + this.description;
        }
        return "Your untrimmed cape is in DANGER because it is " + this.description;
    }

    public static boolean isCapeStorageId(int inventoryID) {
        return Arrays.stream(CapeStorageLocation.values()).anyMatch(capeStorageLocation -> inventoryID == capeStorageLocation.inventoryID);
    }

    public static CapeStorageLocation of(int inventoryID, int deathVarbit) {
        if (inventoryID == 525) {
            for (CapeStorageLocation location : CapeStorageLocation.values()) {
                if (!location.deathVarbits.contains(deathVarbit)) continue;
                return location;
            }
        }
        for (CapeStorageLocation location : CapeStorageLocation.values()) {
            if (location.inventoryID != inventoryID) continue;
            return location;
        }
        return UNKNOWN;
    }

    public static CapeStorageLocation fromDeathRegion(Region region) {
        if (region.equals((Object)Region.BOSS_HESPORI)) {
            return HESPORI;
        }
        if (region.equals((Object)Region.BOSS_VORKATH)) {
            return VORKATH;
        }
        if (region.equals((Object)Region.BOSS_HYDRA)) {
            return HYDRA;
        }
        if (region.equals((Object)Region.BOSS_ZULRAH)) {
            return ZULRAH;
        }
        if (region.equals((Object)Region.RAIDS_THEATRE_OF_BLOOD)) {
            return TOB;
        }
        return GRAVESTONE;
    }

    private static class AlternateInventoryId {
        public static final int DEATH_INVENTORY_ID = 525;
        public static final int UNKNOWN_INVENTORY_ID = -1;

        private AlternateInventoryId() {
        }
    }
}

