/*
 * Decompiled with CFR 0.152.
 */
package runelite.untrimmed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import runelite.untrimmed.CapeStorageLocation;
import runelite.untrimmed.CapeTracker;
import runelite.untrimmed.Region;

public class CapeManager {
    private static final Logger log = LoggerFactory.getLogger(CapeManager.class);
    private Client client;
    private List<Integer> untrimmedCapeIds = new ArrayList<Integer>(Arrays.asList(9810, 9771, 9747, 9789, 9801, 9780, 9753, 9804, 9798, 9783, 9774, 9768, 9948, 9762, 9792, 9759, 9756, 9765, 9786, 9795, 9750, 9777, 9807));
    private CapeTracker capeTracker;
    private static final String CAPE_TRACKER_KEY = "capeTracker";
    private DeathStatus deathStatus = null;

    public CapeManager(Client client, ConfigManager configManager) {
        this.client = client;
        this.capeTracker = new CapeTracker(configManager);
    }

    public void shutDown() {
        this.capeTracker.persistData();
    }

    public CapeStorageLocation capeLocation() {
        ArrayList<CapeStorageLocation> capeLocations = new ArrayList<CapeStorageLocation>();
        for (Map.Entry<CapeStorageLocation, Integer> entry : this.capeTracker.entrySet()) {
            CapeStorageLocation location2 = entry.getKey();
            int count = entry.getValue();
            if (count <= 0) continue;
            capeLocations.add(location2);
        }
        if (capeLocations.isEmpty()) {
            return CapeStorageLocation.UNKNOWN;
        }
        log.debug("CapeLocations=" + capeLocations);
        List safeLocations = capeLocations.stream().filter(CapeStorageLocation::isSafe).collect(Collectors.toList());
        List dangerousLocations = capeLocations.stream().filter(location -> !location.isSafe()).collect(Collectors.toList());
        if (!dangerousLocations.isEmpty()) {
            return (CapeStorageLocation)((Object)dangerousLocations.get(0));
        }
        return (CapeStorageLocation)((Object)safeLocations.get(0));
    }

    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (this.deathStatus != null) {
            this.moveInventoryItemsToDeath();
            this.deathStatus = null;
        }
        ItemContainer itemContainer = itemContainerChanged.getItemContainer();
        int deathVarpId = 261;
        int deathbankVarpValue = this.client.getVarpValue(deathVarpId);
        log.debug("deathBankVarpValue=" + deathbankVarpValue);
        CapeStorageLocation location = CapeStorageLocation.of(itemContainer.getId(), deathbankVarpValue);
        this.capeTracker.put(location, this.untrimmedCapeCount(itemContainer));
    }

    private void moveInventoryItemsToDeath() {
        Item[] itemsBeforeDeath = this.deathStatus.getItems();
        Region regionBeforeDeath = this.deathStatus.getDeathRegion();
        CapeStorageLocation capeStorageLocation = CapeStorageLocation.fromDeathRegion(regionBeforeDeath);
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            log.error("Inventory was null when checking what items remained after reviving");
            return;
        }
        Item[] itemsAfterReviving = inventory.getItems();
        int countBeforeDeath = this.untrimmedCapeCount(itemsBeforeDeath);
        int countAfterReviving = this.untrimmedCapeCount(itemsAfterReviving);
        int countOfCapesMovedToDeath = countBeforeDeath - countAfterReviving;
        this.capeTracker.put(capeStorageLocation, countOfCapesMovedToDeath);
    }

    private int untrimmedCapeCount(ItemContainer itemContainer) {
        Item[] items = itemContainer.getItems();
        return this.untrimmedCapeCount(items);
    }

    private int untrimmedCapeCount(Item[] items) {
        for (Item item : items) {
            if (!this.isUntrimmedCape(item.getId())) continue;
            return item.getQuantity();
        }
        return 0;
    }

    public boolean isUntrimmedCape(int itemId) {
        return this.untrimmedCapeIds.contains(itemId);
    }

    public void onActorDeath(ActorDeath actorDeath) {
        WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation());
        Region region = Region.get(location.getRegionID());
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            log.error("Died and inventory was null.");
            return;
        }
        Item[] items = inventory.getItems();
        this.deathStatus = new DeathStatus(items, region);
    }

    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        if (this.isUntrimmedCape(item.getId())) {
            this.capeTracker.put(CapeStorageLocation.GROUND, item.getQuantity());
        }
    }

    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        if (this.isUntrimmedCape(item.getId())) {
            this.capeTracker.put(CapeStorageLocation.GROUND, 0);
        }
    }

    class DeathStatus {
        private Item[] items;
        private Region deathRegion;

        public DeathStatus(Item[] items, Region deathRegion) {
            this.items = items;
            this.deathRegion = deathRegion;
        }

        public Item[] getItems() {
            return this.items;
        }

        public Region getDeathRegion() {
            return this.deathRegion;
        }
    }
}

