/*
 * Decompiled with CFR 0.152.
 */
package com.TickTracker;

import com.TickTracker.TickTrackerPlugin;
import com.TickTracker.TickTrackerPluginConfiguration;
import com.TickTracker.config.SmallOverlayStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TickTrackerSmallOverlay
extends OverlayPanel {
    private static final int X_OFFSET = 1;
    private static final String SEPARATOR_STRING = " / ";
    private static final String WAITING = "Waiting...";
    private final Client client;
    private final TickTrackerPlugin plugin;
    private final TickTrackerPluginConfiguration config;
    @Inject
    private TickTrackerSmallOverlay overlay;

    @Inject
    private TickTrackerSmallOverlay(Client client, TickTrackerPlugin plugin, TickTrackerPluginConfiguration config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGH);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.drawSmallOverlay() != SmallOverlayStyle.NONE) {
            this.drawSmallOverlay(graphics);
        }
        return null;
    }

    private void drawSmallOverlay(Graphics2D graphics) {
        Widget logoutButton = this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_LOGOUT_BUTTON);
        int xOffset = 1;
        if (logoutButton != null && !logoutButton.isHidden()) {
            xOffset += logoutButton.getWidth();
        }
        int clientWidth = (int)this.client.getRealDimensions().getWidth();
        int textHeight = graphics.getFontMetrics().getAscent() - graphics.getFontMetrics().getDescent();
        if (this.plugin.getDisregardCounter() < this.config.disregardTickCounter()) {
            this.drawSmallOverlaySubsection(graphics, WAITING, clientWidth, xOffset, textHeight, true);
            return;
        }
        if (this.config.drawSmallOverlay() == SmallOverlayStyle.LAST_DIFF || this.config.drawSmallOverlay() == SmallOverlayStyle.BOTH) {
            xOffset += this.drawSmallOverlaySubsection(graphics, String.format("%dms", this.plugin.getTickDiffNS() / this.plugin.getNANOS_PER_MILLIS()), clientWidth, xOffset, textHeight, this.config.smallOverlayColorStyle() == SmallOverlayStyle.PERCENTAGE);
        }
        if (this.config.drawSmallOverlay() == SmallOverlayStyle.BOTH) {
            xOffset += this.drawSmallOverlaySubsection(graphics, SEPARATOR_STRING, clientWidth, xOffset, textHeight, this.config.smallOverlayColorStyle() != SmallOverlayStyle.BOTH);
        }
        if (this.config.drawSmallOverlay() == SmallOverlayStyle.PERCENTAGE || this.config.drawSmallOverlay() == SmallOverlayStyle.BOTH) {
            xOffset += this.drawSmallOverlaySubsection(graphics, String.format("%.2f%%", this.plugin.getTickWithinRangePercent()), clientWidth, xOffset, textHeight, this.config.smallOverlayColorStyle() == SmallOverlayStyle.LAST_DIFF);
        }
    }

    private int drawSmallOverlaySubsection(Graphics2D graphics, String toDraw, int clientWidth, int xOffset, int textHeight, boolean offForSection) {
        int textWidth = graphics.getFontMetrics().stringWidth(toDraw);
        Point point = new Point(clientWidth - textWidth - xOffset, textHeight + this.config.Y_Offset());
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)point, (String)toDraw, (Color)this.colorSelection(offForSection));
        return textWidth;
    }

    public Color colorSelection(boolean offForSection) {
        if (offForSection || this.config.smallOverlayColorStyle() == SmallOverlayStyle.NONE) {
            return Color.YELLOW;
        }
        if (this.plugin.getTickWithinRangePercent() >= (double)this.config.warningColorThresholdUpper()) {
            return Color.GREEN;
        }
        if (this.plugin.getTickWithinRangePercent() >= (double)this.config.warningColorThresholdLower()) {
            return Color.YELLOW;
        }
        return Color.RED;
    }
}

