/*
 * Decompiled with CFR 0.152.
 */
package com.TickTracker;

import com.TickTracker.TickTrackerOverlay;
import com.TickTracker.TickTrackerPluginConfiguration;
import com.TickTracker.TickTrackerSmallOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Tick Tracker", description="Display tick timing variance in an overlay", tags={"tick", "timers", "skill", "pvm", "lag"}, enabledByDefault=false)
public class TickTrackerPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private TickTrackerPluginConfiguration config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TickTrackerOverlay overlay;
    @Inject
    private TickTrackerSmallOverlay SmallOverlay;
    private final long NANOS_PER_MILLIS = 1000000L;
    private final long IDEAL_TICK_LENGTH_NS = 600000000L;
    private long lastTickTimeNS = 0L;
    private long tickDiffNS = 0L;
    private long tickTimePassedNS = 0L;
    private int tickOverThresholdLow = 0;
    private int tickOverThresholdMedium = 0;
    private int tickOverThresholdHigh = 0;
    private int tickWithinRange = 0;
    private int allTickCounter = 0;
    private long runningTickAverageNS = 0L;
    private int disregardCounter = 0;
    private double tickWithinRangePercent = 100.0;
    private boolean isGameStateLoading = false;

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    @Provides
    TickTrackerPluginConfiguration provideConfig(ConfigManager configManager) {
        return (TickTrackerPluginConfiguration)configManager.getConfig(TickTrackerPluginConfiguration.class);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.SmallOverlay);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.SmallOverlay);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        long tickTimeNS = System.nanoTime();
        this.tickDiffNS = tickTimeNS - this.lastTickTimeNS;
        this.lastTickTimeNS = tickTimeNS;
        if (this.isGameStateLoading || this.disregardCounter < this.config.disregardTickCounter()) {
            ++this.disregardCounter;
            return;
        }
        long tickVarianceFromIdealMS = Math.abs(600000000L - this.tickDiffNS) / 1000000L;
        if (tickVarianceFromIdealMS > (long)this.config.warnLargeTickDiffValue() && this.config.warnLargeTickDiff() && this.allTickCounter > this.config.disregardTickCounter()) {
            this.sendChatMessage("Tick was " + this.tickDiffNS / 1000000L + "ms long");
        }
        if (tickVarianceFromIdealMS > (long)this.config.getThresholdHigh()) {
            ++this.tickOverThresholdHigh;
        } else if (tickVarianceFromIdealMS > (long)this.config.getThresholdMedium()) {
            ++this.tickOverThresholdMedium;
        } else if (tickVarianceFromIdealMS > (long)this.config.getThresholdLow()) {
            ++this.tickOverThresholdLow;
        } else {
            ++this.tickWithinRange;
        }
        ++this.allTickCounter;
        this.tickTimePassedNS += this.tickDiffNS;
        this.runningTickAverageNS = this.tickTimePassedNS / (long)this.allTickCounter;
        this.tickWithinRangePercent = (double)this.tickWithinRange * 100.0 / (double)this.allTickCounter;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        boolean bl = this.isGameStateLoading = event.getGameState() == GameState.LOADING;
        if (event.getGameState() == GameState.HOPPING || event.getGameState() == GameState.LOGGING_IN) {
            this.resetStats(false);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String key;
        if ("TickTracker".equals(event.getGroup()) && ("varianceHigh".equals(key = event.getKey()) || "varianceMedium".equals(key) || "varianceLow".equals(key))) {
            this.resetStats(true);
        }
    }

    private void resetStats(boolean onlyVarianceRelevantStats) {
        this.tickOverThresholdHigh = 0;
        this.tickOverThresholdMedium = 0;
        this.tickOverThresholdLow = 0;
        this.tickWithinRange = 0;
        this.allTickCounter = 0;
        this.tickTimePassedNS = 0L;
        this.tickWithinRangePercent = 100.0;
        if (onlyVarianceRelevantStats) {
            return;
        }
        this.lastTickTimeNS = 0L;
        this.tickDiffNS = 0L;
        this.runningTickAverageNS = 0L;
        this.disregardCounter = 0;
    }

    public Client getClient() {
        return this.client;
    }

    public TickTrackerPluginConfiguration getConfig() {
        return this.config;
    }

    public ChatMessageManager getChatMessageManager() {
        return this.chatMessageManager;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public TickTrackerOverlay getOverlay() {
        return this.overlay;
    }

    public TickTrackerSmallOverlay getSmallOverlay() {
        return this.SmallOverlay;
    }

    public long getNANOS_PER_MILLIS() {
        return this.NANOS_PER_MILLIS;
    }

    public long getIDEAL_TICK_LENGTH_NS() {
        return this.IDEAL_TICK_LENGTH_NS;
    }

    public long getLastTickTimeNS() {
        return this.lastTickTimeNS;
    }

    public long getTickDiffNS() {
        return this.tickDiffNS;
    }

    public long getTickTimePassedNS() {
        return this.tickTimePassedNS;
    }

    public int getTickOverThresholdLow() {
        return this.tickOverThresholdLow;
    }

    public int getTickOverThresholdMedium() {
        return this.tickOverThresholdMedium;
    }

    public int getTickOverThresholdHigh() {
        return this.tickOverThresholdHigh;
    }

    public int getTickWithinRange() {
        return this.tickWithinRange;
    }

    public int getAllTickCounter() {
        return this.allTickCounter;
    }

    public long getRunningTickAverageNS() {
        return this.runningTickAverageNS;
    }

    public int getDisregardCounter() {
        return this.disregardCounter;
    }

    public double getTickWithinRangePercent() {
        return this.tickWithinRangePercent;
    }

    public boolean isGameStateLoading() {
        return this.isGameStateLoading;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setConfig(TickTrackerPluginConfiguration config) {
        this.config = config;
    }

    public void setChatMessageManager(ChatMessageManager chatMessageManager) {
        this.chatMessageManager = chatMessageManager;
    }

    public void setClientThread(ClientThread clientThread) {
        this.clientThread = clientThread;
    }

    public void setOverlayManager(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
    }

    public void setOverlay(TickTrackerOverlay overlay) {
        this.overlay = overlay;
    }

    public void setSmallOverlay(TickTrackerSmallOverlay SmallOverlay) {
        this.SmallOverlay = SmallOverlay;
    }

    public void setLastTickTimeNS(long lastTickTimeNS) {
        this.lastTickTimeNS = lastTickTimeNS;
    }

    public void setTickDiffNS(long tickDiffNS) {
        this.tickDiffNS = tickDiffNS;
    }

    public void setTickTimePassedNS(long tickTimePassedNS) {
        this.tickTimePassedNS = tickTimePassedNS;
    }

    public void setTickOverThresholdLow(int tickOverThresholdLow) {
        this.tickOverThresholdLow = tickOverThresholdLow;
    }

    public void setTickOverThresholdMedium(int tickOverThresholdMedium) {
        this.tickOverThresholdMedium = tickOverThresholdMedium;
    }

    public void setTickOverThresholdHigh(int tickOverThresholdHigh) {
        this.tickOverThresholdHigh = tickOverThresholdHigh;
    }

    public void setTickWithinRange(int tickWithinRange) {
        this.tickWithinRange = tickWithinRange;
    }

    public void setAllTickCounter(int allTickCounter) {
        this.allTickCounter = allTickCounter;
    }

    public void setRunningTickAverageNS(long runningTickAverageNS) {
        this.runningTickAverageNS = runningTickAverageNS;
    }

    public void setDisregardCounter(int disregardCounter) {
        this.disregardCounter = disregardCounter;
    }

    public void setTickWithinRangePercent(double tickWithinRangePercent) {
        this.tickWithinRangePercent = tickWithinRangePercent;
    }

    public void setGameStateLoading(boolean isGameStateLoading) {
        this.isGameStateLoading = isGameStateLoading;
    }
}

