/*
 * Decompiled with CFR 0.152.
 */
package com.TickTracker;

import com.TickTracker.TickTrackerPlugin;
import com.TickTracker.TickTrackerPluginConfiguration;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class TickTrackerOverlay
extends OverlayPanel {
    private final Client client;
    private final TickTrackerPlugin plugin;
    private final TickTrackerPluginConfiguration config;

    @Inject
    private TickTrackerOverlay(Client client, TickTrackerPlugin plugin, TickTrackerPluginConfiguration config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.drawLargeOverlay()) {
            this.drawExtraInformation(graphics);
        }
        return super.render(graphics);
    }

    private LineComponent tickOverThresholdLineComponent(int tickOverThreshold, String configThreshold) {
        return LineComponent.builder().right(String.format("%d (%.2f %%)", tickOverThreshold, (double)tickOverThreshold * 100.0 / (double)this.plugin.getAllTickCounter())).left("+/- >" + configThreshold).build();
    }

    private void drawExtraInformation(Graphics2D graphics) {
        this.panelComponent.getChildren().addAll(Arrays.asList(TitleComponent.builder().text("Ticks").build(), this.tickOverThresholdLineComponent(this.plugin.getTickOverThresholdHigh(), String.valueOf(this.config.getThresholdHigh())), this.tickOverThresholdLineComponent(this.plugin.getTickOverThresholdMedium(), String.valueOf(this.config.getThresholdMedium())), this.tickOverThresholdLineComponent(this.plugin.getTickOverThresholdLow(), String.valueOf(this.config.getThresholdLow())), LineComponent.builder().right(String.format("%d (%.2f %%)", this.plugin.getTickWithinRange(), this.plugin.getTickWithinRangePercent())).left("Good").build(), LineComponent.builder().right(String.valueOf(this.plugin.getAllTickCounter())).left("Total").build(), LineComponent.builder().right(String.valueOf(this.plugin.getTickDiffNS() / this.plugin.getNANOS_PER_MILLIS())).left("Last Tick ms").build(), LineComponent.builder().right(String.valueOf(this.plugin.getRunningTickAverageNS() / this.plugin.getNANOS_PER_MILLIS())).left("Tick Average ms").build()));
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth("average tick ms+extra fill600"), 0));
    }
}

