/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting.datatypes;

import com.autocasting.datatypes.SpellCost;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum Spell {
    NO_SPELL("No spell selected", 1212, -1, 0, null),
    WIND_STRIKE("Wind Strike", 15, 1, 1, SpellCost.WIND_STRIKE),
    WATER_STRIKE("Water Strike", 17, 5, 2, SpellCost.WATER_STRIKE),
    EARTH_STRIKE("Earth Strike", 19, 9, 3, SpellCost.EARTH_STRIKE),
    FIRE_STRIKE("Fire Strike", 21, 13, 4, SpellCost.FIRE_STRIKE),
    WIND_BOLT("Wind Bolt", 23, 17, 5, SpellCost.WIND_BOLT),
    WATER_BOLT("Water Bolt", 26, 23, 6, SpellCost.WATER_BOLT),
    EARTH_BOLT("Earth Bolt", 29, 29, 7, SpellCost.EARTH_BOLT),
    FIRE_BOLT("Fire Bolt", 32, 35, 8, SpellCost.FIRE_BOLT),
    WIND_BLAST("Wind Blast", 35, 41, 9, SpellCost.WIND_BLAST),
    WATER_BLAST("Water Blast", 38, 47, 10, SpellCost.WATER_BLAST),
    EARTH_BLAST("Earth Blast", 40, 53, 11, SpellCost.EARTH_BLAST),
    FIRE_BLAST("Fire Blast", 44, 59, 12, SpellCost.FIRE_BLAST),
    WIND_WAVE("Wind Wave", 46, 62, 13, SpellCost.WIND_WAVE),
    WATER_WAVE("Water Wave", 48, 65, 14, SpellCost.WATER_WAVE),
    EARTH_WAVE("Earth Wave", 51, 70, 15, SpellCost.EARTH_WAVE),
    FIRE_WAVE("Fire Wave", 52, 75, 16, SpellCost.FIRE_WAVE),
    CRUMBLE_UNDEAD("Crumble Undead", 34, 39, 17, SpellCost.CRUMBLE_UNDEAD),
    MAGIC_DART("Magic Dart", 324, 50, 18, SpellCost.MAGIC_DART),
    CLAWS_OF_GUTHIX("Claws of Guthix", 60, 60, 19, SpellCost.CLAWS_OF_GUTHIX),
    FLAMES_OF_ZAMORAK("Flames of Zamorak", 59, 60, 20, SpellCost.FLAMES_OF_ZAMORAK),
    SMOKE_RUSH("Smoke Rush", 329, 50, 31, SpellCost.SMOKE_RUSH),
    SHADOW_RUSH("Shadow Rush", 337, 52, 32, SpellCost.SHADOW_RUSH),
    BLOOD_RUSH("Blood Rush", 333, 56, 33, SpellCost.BLOOD_RUSH),
    ICE_RUSH("Ice Rush", 325, 58, 34, SpellCost.ICE_RUSH),
    SMOKE_BURST("Smoke Burst", 330, 62, 35, SpellCost.SMOKE_BURST),
    SHADOW_BURST("Shadow Burst", 338, 64, 36, SpellCost.SHADOW_BURST),
    BLOOD_BURST("Blood Burst", 334, 68, 37, SpellCost.BLOOD_BURST),
    ICE_BURST("Ice Burst", 326, 70, 38, SpellCost.ICE_BURST),
    SMOKE_BLITZ("Smoke Blitz", 331, 74, 39, SpellCost.SMOKE_BLITZ),
    SHADOW_BLITZ("Shadow Blitz", 339, 76, 40, SpellCost.SHADOW_BLITZ),
    BLOOD_BLITZ("Blood Blitz", 335, 80, 41, SpellCost.BLOOD_BLITZ),
    ICE_BLITZ("Ice Blitz", 327, 82, 42, SpellCost.ICE_BLITZ),
    SMOKE_BARRAGE("Smoke Barrage", 332, 86, 43, SpellCost.SMOKE_BARRAGE),
    SHADOW_BARRAGE("Shadow Barrage", 340, 88, 44, SpellCost.SHADOW_BARRAGE),
    BLOOD_BARRAGE("Blood Barrage", 336, 92, 45, SpellCost.BLOOD_BARRAGE),
    ICE_BARRAGE("Ice Barrage", 328, 94, 46, SpellCost.ICE_BARRAGE),
    IBAN_BLAST("Iban's Blast", 53, 50, 47, SpellCost.IBAN_BLAST),
    WIND_SURGE("Wind Surge", 362, 81, 48, SpellCost.WIND_SURGE),
    WATER_SURGE("Water Surge", 363, 85, 49, SpellCost.WATER_SURGE),
    EARTH_SURGE("Earth Surge", 364, 90, 50, SpellCost.EARTH_SURGE),
    FIRE_SURGE("Fire Surge", 365, 95, 51, SpellCost.FIRE_SURGE),
    SARADOMIN_STRIKE("Saradomin Strike", 61, 60, 52, SpellCost.SARADOMIN_STRIKE),
    INFERIOR_DEMONBANE("Inferior Demonbane", 1302, 44, 53, SpellCost.INFERIOR_DEMONBANE),
    SUPERIOR_DEMONBANE("Superior Demonbane", 1303, 62, 54, SpellCost.SUPERIOR_DEMONBANE),
    DARK_DEMONBANE("Dark Demonbane", 1304, 82, 55, SpellCost.DARK_DEMONBANE),
    GHOSTLY_GRASP("Ghostly Grasp", 1267, 35, 56, SpellCost.GHOSTLY_GRASP),
    SKELETAL_GRASP("Skeletal Grasp", 1268, 56, 57, SpellCost.SKELETAL_GRASP),
    UNDEAD_GRASP("Undead Grasp", 1269, 79, 58, SpellCost.UNDEAD_GRASP);

    private final String name;
    private final int spriteID;
    private final int levelRequirement;
    private final int varbitValue;
    private final SpellCost spellCost;
    private static final Map<Integer, Spell> AUTOCAST_SPELLS_MAP;

    public static Spell getSpell(int varbitValue) {
        return AUTOCAST_SPELLS_MAP.getOrDefault(varbitValue, null);
    }

    private Spell(String name, int spriteID, int levelRequirement, int varbitValue, SpellCost spellCost) {
        this.name = name;
        this.spriteID = spriteID;
        this.levelRequirement = levelRequirement;
        this.varbitValue = varbitValue;
        this.spellCost = spellCost;
    }

    public String getName() {
        return this.name;
    }

    public int getSpriteID() {
        return this.spriteID;
    }

    public int getLevelRequirement() {
        return this.levelRequirement;
    }

    public int getVarbitValue() {
        return this.varbitValue;
    }

    public SpellCost getSpellCost() {
        return this.spellCost;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Spell spell : Spell.values()) {
            builder.put((Object)spell.getVarbitValue(), (Object)spell);
        }
        AUTOCAST_SPELLS_MAP = builder.build();
    }
}

