/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting.datatypes;

import com.autocasting.datatypes.RuneType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum RuneItem {
    AIR_RUNE(556, new RuneType[]{RuneType.AIR}),
    AIR_RUNE_6422(6422, new RuneType[]{RuneType.AIR}),
    AIR_RUNE_7558(7558, new RuneType[]{RuneType.AIR}),
    AIR_RUNE_9693(9693, new RuneType[]{RuneType.AIR}),
    AIR_RUNE_11688(11688, new RuneType[]{RuneType.AIR}),
    AIR_RUNE_NZ(11715, new RuneType[]{RuneType.AIR}),
    WATER_RUNE(555, new RuneType[]{RuneType.WATER}),
    WATER_RUNE_6424(6424, new RuneType[]{RuneType.WATER}),
    WATER_RUNE_7556(7556, new RuneType[]{RuneType.WATER}),
    WATER_RUNE_9691(9691, new RuneType[]{RuneType.WATER}),
    WATER_RUNE_11687(11687, new RuneType[]{RuneType.WATER}),
    WATER_RUNE_NZ(11716, new RuneType[]{RuneType.WATER}),
    EARTH_RUNE(557, new RuneType[]{RuneType.EARTH}),
    EARTH_RUNE_6426(6426, new RuneType[]{RuneType.EARTH}),
    EARTH_RUNE_9695(9695, new RuneType[]{RuneType.EARTH}),
    EARTH_RUNE_11689(11689, new RuneType[]{RuneType.EARTH}),
    EARTH_RUNE_NZ(11717, new RuneType[]{RuneType.EARTH}),
    FIRE_RUNE(554, new RuneType[]{RuneType.FIRE}),
    FIRE_RUNE_6428(6428, new RuneType[]{RuneType.FIRE}),
    FIRE_RUNE_7554(7554, new RuneType[]{RuneType.FIRE}),
    FIRE_RUNE_9699(9699, new RuneType[]{RuneType.FIRE}),
    FIRE_RUNE_11686(11686, new RuneType[]{RuneType.FIRE}),
    FIRE_RUNE_NZ(11718, new RuneType[]{RuneType.FIRE}),
    MIND_RUNE(558, new RuneType[]{RuneType.MIND}),
    MIND_RUNE_6436(6436, new RuneType[]{RuneType.MIND}),
    MIND_RUNE_9697(9697, new RuneType[]{RuneType.MIND}),
    MIND_RUNE_11690(11690, new RuneType[]{RuneType.MIND}),
    BODY_RUNE(559, new RuneType[]{RuneType.BODY}),
    BODY_RUNE_6438(6438, new RuneType[]{RuneType.BODY}),
    BODY_RUNE_11691(11691, new RuneType[]{RuneType.BODY}),
    COSMIC_RUNE(564, new RuneType[]{RuneType.COSMIC}),
    COSMIC_RUNE_11696(11696, new RuneType[]{RuneType.COSMIC}),
    CHAOS_RUNE(562, new RuneType[]{RuneType.CHAOS}),
    CHAOS_RUNE_6430(6430, new RuneType[]{RuneType.CHAOS}),
    CHAOS_RUNE_7560(7560, new RuneType[]{RuneType.CHAOS}),
    CHAOS_RUNE_11694(11694, new RuneType[]{RuneType.CHAOS}),
    CHAOS_RUNE_NZ(11712, new RuneType[]{RuneType.CHAOS}),
    NATURE_RUNE(561, new RuneType[]{RuneType.NATURE}),
    NATURE_RUNE_11693(11693, new RuneType[]{RuneType.NATURE}),
    LAW_RUNE(563, new RuneType[]{RuneType.LAW}),
    LAW_RUNE_6434(6434, new RuneType[]{RuneType.LAW}),
    LAW_RUNE_11695(11695, new RuneType[]{RuneType.LAW}),
    DEATH_RUNE(560, new RuneType[]{RuneType.DEATH}),
    DEATH_RUNE_6432(6432, new RuneType[]{RuneType.DEATH}),
    DEATH_RUNE_11692(11692, new RuneType[]{RuneType.DEATH}),
    DEATH_RUNE_NZ(11713, new RuneType[]{RuneType.DEATH}),
    ASTRAL_RUNE(9075, new RuneType[]{RuneType.ASTRAL}),
    ASTRAL_RUNE_11699(11699, new RuneType[]{RuneType.ASTRAL}),
    BLOOD_RUNE(565, new RuneType[]{RuneType.BLOOD}),
    BLOOD_RUNE_11697(11697, new RuneType[]{RuneType.BLOOD}),
    BLOOD_RUNE_NZ(11714, new RuneType[]{RuneType.BLOOD}),
    SOUL_RUNE(566, new RuneType[]{RuneType.SOUL}),
    SOUL_RUNE_11698(11698, new RuneType[]{RuneType.SOUL}),
    WRATH_RUNE(21880, new RuneType[]{RuneType.WRATH}),
    WRATH_RUNE_22208(22208, new RuneType[]{RuneType.WRATH}),
    MIST_RUNE(4695, new RuneType[]{RuneType.AIR, RuneType.WATER}),
    DUST_RUNE(4696, new RuneType[]{RuneType.AIR, RuneType.EARTH}),
    MUD_RUNE(4698, new RuneType[]{RuneType.WATER, RuneType.EARTH}),
    SMOKE_RUNE(4697, new RuneType[]{RuneType.AIR, RuneType.FIRE}),
    STEAM_RUNE(4694, new RuneType[]{RuneType.WATER, RuneType.FIRE}),
    LAVA_RUNE(4699, new RuneType[]{RuneType.EARTH, RuneType.FIRE});

    private final int id;
    private final RuneType[] matchingTypes;
    private static final Map<Integer, RuneItem> RUNE_ITEM_MAP;

    public static RuneItem getRuneItem(int itemId) {
        return RUNE_ITEM_MAP.getOrDefault(itemId, null);
    }

    private RuneItem(int id, RuneType[] matchingTypes) {
        this.id = id;
        this.matchingTypes = matchingTypes;
    }

    public int getId() {
        return this.id;
    }

    public RuneType[] getMatchingTypes() {
        return this.matchingTypes;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RuneItem item : RuneItem.values()) {
            builder.put((Object)item.getId(), (Object)item);
        }
        RUNE_ITEM_MAP = builder.build();
    }
}

