/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting.datatypes;

import com.autocasting.datatypes.PouchType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum Pouch {
    RUNE_POUCH(12791, PouchType.THREE_SLOTS),
    RUNE_POUCH_L(24416, PouchType.THREE_SLOTS),
    DIVINE_RUNE_POUCH(27281, PouchType.FOUR_SLOTS),
    DIVINE_RUNE_POUCH_L(27509, PouchType.FOUR_SLOTS),
    LMS_POUCH(23650, PouchType.LMS),
    EMIRS_ARENA_POUCH(27086, PouchType.INFINITE);

    private final int id;
    private final PouchType pouchType;
    private static final Map<Integer, Pouch> POUCH_MAP;

    public static Pouch getPouch(int itemId) {
        return POUCH_MAP.getOrDefault(itemId, null);
    }

    private Pouch(int id, PouchType pouchType) {
        this.id = id;
        this.pouchType = pouchType;
    }

    public int getId() {
        return this.id;
    }

    public PouchType getPouchType() {
        return this.pouchType;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Pouch pouch : Pouch.values()) {
            builder.put((Object)pouch.getId(), (Object)pouch);
        }
        POUCH_MAP = builder.build();
    }
}

